% Skript mehrdeutigkeit_1.m, in dem die Mehrdeutigkeit
% der zeitdiskreten Signale untersucht wird.
% Arbeitet mit Modell mehrdeutigkeit1.slx
clear;
% -------- Parameter des Systems
f0 = 200;         % Grundfrequenz (k = 0)
fs = 1000;        % Abtastfrequenz;
Ts = 1/fs;
% Erstes Signal
k1 = 0;
% k1 = 2;
f1 = f0+k1*fs;
phi1 = 0;
if f1 < 0
    f1 = -f0+k1*fs;
    phi1 = pi;
end;
f1,
% Zweites Signal
k2 = -2;
f2 = f0+k2*fs;
phi2 = 0;
if f2 < 0
    f2 = -f0+(-k2)*fs;
    phi2 = pi;
end;
f2,
% -------- Aufruf der Simulation
N = 512;       % Gre der FFT fr die spektrale Leistung
wp = sum(hanning(N).^2);     % Leistung der Fensterwerte
Tf = 1;        % Dauer der Simulation
sim('mehrdeutigkeit1',[0,Tf]);
t = y.time;       % Simulationszeitschritte
x1k = y.data(:,1); % Kontinuierliches Signal der Freq. f1 = f0+k1*fs  
x2k = y.data(:,2); % Kontinuierliches Signal der Freq. f2 = f0+k2*fs 

x1 = y.data(:,3);  % Abtastwerte des Signals der Freq. f1 = f0+k1*fs
x2 = y.data(:,4);  % Abtastwerte des Signals der Freq. f2 = f0+k2*fs

xinterp = y.data(:,5);  % Nullter Ordnung Interpolation

figure(1);     clf;
subplot(211),  plot(t, x1k, t, xinterp,'k');
hold on;   plot(t, x1, 'k', 'LineWidth', 1.5)
title(['Abtastwerte und Signal mit k1 = ',num2str(k1),...
    ' (f0 = ',num2str(f0),' Hz; fs = ',num2str(fs),' Hz)']);
xlabel('Zeit in s');    grid on;
La = axis;    axis([0.01, 0.02, 1.2*La(3:4)]);
hold off;
subplot(212),  plot(t, x2k, t, xinterp,'k');
hold on;   plot(t, x2, 'k', 'LineWidth', 1.5)
title(['Abtastwerte und Signal mit k2 = ',num2str(k2),...
    ' (f0 = ',num2str(f0),' Hz; fs = ',num2str(fs),' Hz)']);
xlabel('Zeit in s');    grid on;
La = axis;    axis([0.01, 0.02, 1.2*La(3:4)]);
hold off;

figure(2);     clf;
plot(t, x1k, t, x2k,'k',t, xinterp, 'k', 'LineWidth', 1.5);
hold on;   plot(t, x1,'k','LineWidth',2);
La = axis;    axis([0.01, 0.015, 1.2*La(3:4)]);
title(['Abtastwerte und Signale mit k1 = ',num2str(k1),' und k2 = ',...
    num2str(k2),' (f0 = ',num2str(f0),' Hz; fs = ',num2str(fs),' Hz)']);
xlabel('Zeit in s');    grid on;
hold off;