% Skript leakage_4.m, in dem man den Leakage-Effekt
% fr ein cosinusfrmiges Signal untersucht 
% Es werden Fensterfunktionen eingesetzt und das
% Simulink-Modell leakage4.slx benutzt
clear;

% ------- Signal Initialisierungen
N = 1024;       % Anzahl der Abtastwerte in T0
fs = 1024;      % Abtastfrequenz
Ts = 1/fs;      % Abtastperiode
T0 = N*Ts;      % Dauer des Untersuchungsintervalls
ampl1 = 10;     % Amplitude
%ampl1 = 0;     % Amplitude
phi1 = pi/3;    % Nullphase
ampl2 = 5;      % Amplitude
%ampl2 = 0;     % Amplitude
phi2 = pi/5;    % Nullphase
fsig1 = 100.5;  % Frequenz des Signals 1
fsig2 = 150.3;  % Frequenz des Signals 2
pw = sum(hanning(N).^2)/N;   % Mittlere Leistung der Fensterwerte
noise = 2;      % Varianz des Rauschens

% ------- Aufruf der Simulation
Tfinal = 100;
sim('leakage4', [0,Tfinal]);
figure(1);     clf;
plot((0:N-1)*fs/N, 10*log10(Y(:,:,end)));
title(['Spektrale Leistung fr N=',num2str(N),'; fs = ',num2str(fs),...
    'Hz und fsig1=',num2str(fsig1),' Hz, fsig2=',num2str(fsig2),' Hz']);
xlabel('Hz');   grid on;
axis tight;xlabel('Hz');   grid on;
axis tight;
% ------- Leistung des Signals aus der spektralen Leistung
P = Y(:,:,end);
Pgesamt = sum(P),
Pideal = ampl1^2/2 + ampl2^2/2 + noise,