% Skript leakage_2.m, in dem man den Leakage-Effekt
% fr ein cosinusfrmiges Signal untersucht 
% Es werden Fensterfunktionen eingesetzt und das
% Simulink-Modell leakage2.slx benutzt
clear;

% ------- Signal Initialisierungen
N = 1024;       % Anzahl der Abtastwerte in T0
fs = 1024;      % Abtastfrequenz
Ts = 1/fs;      % Abtastperiode
T0 = N*Ts;      % Dauer des Untersuchungsintervalls
ampl = 10;      % Amplitude
phi = pi/3;     % Nullphase
fsig = 100.5;   % Frequenz des Signals
%fsig = 105;     % Frequenz des Signals
pw = sum(hanning(N).^2)/N;   % Mittlere Leistung der Fensterwerte
% ------- Aufruf der Simulation
Tfinal = 5;
sim('leakage2', [0,Tfinal]);
figure(1);     clf;
plot((0:N-1)*fs/N, 10*log10(Y(:,:,end)));
title(['Spektrale Leistung fr N=',num2str(N),'; fs = ',num2str(fs),...
    'Hz und fsig = ',num2str(fsig),'Hz']);
xlabel('Hz');   grid on;
axis tight;
% ------- Leistung des Signals aus der spektralen Leistung
P = Y(:,:,end);
Pgesamt = sum(P),
Pideal = ampl^2/2,