% Skript leakage_1.m, in dem man den Leakage-Effekt
% fr ein cosinusfrmiges Signal untersucht 
clear;

% ------- Signal Initialisierungen
T0 = 1;         % Dauer des Untersuchungsintervalls
N = 20;         % Anzahl der Abtastwerte in T0
Ts = T0/N;      % Abtastperiode
fs = 1/Ts;      % Abtastfrequenz
ampl = 10;      % Amplitude
phi = pi/3;     % Nullphase
m = 5;          % Faktor fr die Periode des Signals
m = 5.4;
n = 0:N-1;      % Indizes der Abtastwerte
k =n;           % Indizes der FFT
% ------- Kontinuierliches Signal der Frequenz m/T0
dt = Ts/10;
t = 0:dt:T0;
xt = ampl*cos(2*pi*t*m/T0 + phi);
% ------- Abgetastetes Signal
xn = ampl*cos(2*pi*m*n/N + phi);
% ------- DFT von xn
Xk = fft(xn);      betrag_Xk = abs(Xk)/N;
% ------- Xk fr k kontinuierlich
kk = 0:0.001:N;        np = length(kk);
Xkk = zeros(1, np);
for p = 1:np
    Xkk(p) = sum(xn.*exp(-j*2*pi*kk(p)*n/N));
end;
Xkk=Xkk;        betrag_Xkk = abs(Xkk)/N;
% ------- Darstellungen
figure(1);    clf;
subplot(211), stem(n*Ts, xn, 'LineWidth', 1.5);
hold on;      plot(t,xt);
title(['Signal und die Abtastwerte fr N = ',num2str(N),' und m = '...
    ,num2str(m)]);
xlabel('Zeit in s');     grid on;    hold off;
subplot(212), stem(k, betrag_Xk, 'LineWidth', 1.5);
hold on;    plot(kk, betrag_Xkk);
title(['Betrag der DFT/N fr N = ',num2str(N),' und m = '...
    ,num2str(m)]);
xlabel(['Frequenz in Hz (fs = ',num2str(fs), 'Hz)']);
grid on;                hold off;
