% Skript fourier_transf_puls_4.m, in dem die Fourier-
% Transformation eines abklingenden Exponentialfunktion
% untersucht wird. Arbeitet mit Modell fourier_transf_puls4.slx
clear;
% -------- Parameter des Systems
N = 512;
fs = 1000;
Ts = 1/fs;
Tsig = N*Ts;       % Periode das das aperiodische Signal ergibt
% -------- Eingangssignal (abklingenden Exponentialfunktion)
a = 1/(Tsig/4);
dt = Ts/10;
t = 0:dt:Tsig-dt;
e_faktor = 1;
yi = e_faktor*exp(-a*t) + 0.5*cos(2*pi*t/(Tsig/40));     % Ohne Leakage
%yi = e_faktor*exp(-a*t) + 0.5*cos(2*pi*t/(Tsig/40.3));  % Mit Leakage
% -------- Aufruf der Simulation
Tf = 3*Tsig;       % 3 Untersuchungsintervalle fr die Simulation
w = ones(1,N);
%w = hanning(N);   % Fenster-Funktion
%w = hamming(N);
%w = exp(-(0:N-1)/150);
wf = sqrt(N/sum(w.^2));
sim('fourier_transf_puls4', [0,Tf]);
Y = y.signals.values;  % Betrge der FFT*Ts
Y = Y(:,:,end);        % Betrag der FFT*Ts des letzten Datenpuffers
phi = y3.signals.values; % Winkel der FFT des letzten Datenpuffers
phi = phi(:,:,end);

figure(1);   clf;
xdw = y1.signals.values(:,1,end);
xd =  y2.signals.values(:,1,end);

subplot(211), stem((0:N-1)*Ts, [xd, xdw]);
title(['Exponentialfunktion mit 1/a = ',num2str(1/a),...
    's und Anteil mit fsig = ',num2str(40/Tsig),' Hz']);
xlabel('s');    grid on;
La = axis;    axis([0, Tsig, La(3:4)]);
subplot(212), plot((-(N/2):(N/2-1))*fs/N, 10*log10(fftshift(Y)),'r');
title(['Betrag der FFT*Ts und korrekter Betragsspektrum']);
xlabel('Hz');     grid on;    ylabel('10*log10(Ts*Xk)');
axis tight;
% ------- Analytisches Fourier-Spektrum fr die Exponentialfunktion
df = fs/N;
f = -fs/2:df:fs/2-df;
Yid = 1./(sqrt(a^2 + (2*pi*f).^2));
hold on;
if e_faktor ~= 0
     plot((-(N/2):(N/2-1))*fs/N, 10*log10(Yid));
end;     
La = axis;     axis([La(1:2),-40, -5]);
hold off;   legend('DFT gemessene FT', 'Analytische FT');
% ------- Parseval Theorem
E_zeit = sum(xd.^2)*Ts,
E_freq = sum(Y.^2)*fs/N,

figure(2);     clf;
plot((-(N/2):(N/2-1))*fs/N, 10*log10(fftshift(Y)),'r'); 
title('Betragspektrum und Betrag der DFT*Ts');
xlabel('Hz');       ylabel('10*log10(| |)');       grid on;
if e_faktor == 1;
   hold on;
      plot((-(N/2):(N/2-1))*fs/N, 10*log10(Yid));
   hold off;
end;   


