% Skript fourier_transf_puls_2.m, in dem die Fourier-
% Transformation eines dreieckigen Pulses untersucht wird
% Arbeitet mit Modell fourier_transf_puls2.slx
clear;
% -------- Parameter des Systems
tau_abs = 50e-3;   % Absolute Dauer des Pulses in s
N = 256;           % Anzahl Abtastwerte im Untersuchungsintervall
%N = 128;          % Anzahl Abtastwerte im Untersuchungsintervall
%fs = 1000;         % Abtastfrequenz
fs = 400;         % Abtastfrequenz
Ts = 1/fs;         % Abtastperiode
Tsig = N*Ts;       % Untersuchungsintervall des aperiodische Signal
tau = tau_abs*100/Tsig; % Dauer des Pulses in %
h = 2;             % Hhe des Pulses
% -------- Aufruf der Simulation
Tf = 5*Tsig;       % 5 Perioden als dauer der Simulation
sim('fourier_transf_puls2', [0,Tf]);
Y = y.signals.values;  % Betrge der FFT*Ts
Y = Y(:,:,end);        % Betrag der FFT*Ts des letzten Datenpuffers

figure(1);   clf;
n_ones = round(tau_abs/Ts);
xd = y1.signals.values(:,1,end);
t = y1.time;
subplot(211), stem((0:N-1)*Ts, xd);
title(['Puls der Dauer tau = ',num2str(tau_abs),' s']);
xlabel('s');    grid on;
La = axis;    axis([0, Tsig, La(3:4)]);
%subplot(212), plot((0:N-1)*fs/N, 10*log10(Y));
subplot(212), stem((0:N-1)*fs/N, 10*log10(Y));
title(['Betrag der FFT des dreieckigen Pulses der Dauer tau =',num2str(tau_abs),' s']);
xlabel('Hz');     grid on;    ylabel('10*log10(Ts*|Xk|)');
% ------- Analytisches Fourier-Spektrum
df = fs/N;
f = 0:df:fs-df;
Yid = h*(4/tau_abs)*(1./((2*pi*f).^2)).*(1-cos(2*pi*f*tau_abs/2));
hold on;
plot((0:N-1)*fs/N, 10*log10(Yid), 'r');
La = axis;     axis([0,fs,-60, -5]);
hold off;
% ------- Parseval Theorem
E_zeit = sum(xd.^2)*Ts,
E_freq = sum(Y.^2)*fs/N,



