% Skript fourier_transf_puls_1.m, in dem die Fourier-
% Transformation eines Pulses untersucht wird
% Arbeitet mit Modell fourier_transf_puls1.slx
clear;
% -------- Parameter des Systems
tau_abs = 25e-3;   % Absolute Dauer des Pulses in s
%N = 256;           % Anzahl Abtastwerte im Untersuchungsintervall
N = 128;          % Anzahl Abtastwerte im Untersuchungsintervall
%fs = 1000;         % Abtastfrequenz
fs = 400;         % Abtastfrequenz
Ts = 1/fs;         % Abtastperiode
Tsig = N*Ts;       % Untersuchungsintervall des aperiodische Signal
tau = tau_abs*100/Tsig; % Dauer des Pulses in %
h = 1;             % Hhe des Pulses
% -------- Aufruf der Simulation
Tf = 5*Tsig;       % 5 Perioden als dauer der Simulation
sim('fourier_transf_puls1', [0,Tf]);
Y = y.signals.values;  % Betrge der FFT*Ts
Y = Y(:,:,end);        % Betrag der FFT*Ts des letzten Datenpuffers

figure(1);   clf;
n_ones = round(tau_abs/Ts);    % Anzahl der Abtastwerte fr den Puls
xd = h*[ones(1, n_ones), zeros(1, N-n_ones)]; % Pulssignal 
subplot(211), stem((0:N-1)*Ts, xd);
title(['Puls der Dauer tau = ',num2str(tau_abs),' s, fs = ',...
    num2str(fs),' Hz, N = ',num2str(N)]);
xlabel('s');    grid on;    axis tight;
%subplot(212), plot((0:N-1)*fs/N, 10*log10(Y));
subplot(212), stem((0:N-1)*fs/N, 10*log10(Y));
title(['Betrag der FFT des Pulses der Dauer tau =',num2str(tau_abs),' s']);
xlabel('Hz');     grid on;    ylabel('10*log10(Ts*|Xk|)');
% ------- Analytisches Fourier-Spektrum
df = fs/N;
f = 0:df:fs-df;
Yid = abs((tau_abs)*h*sinc(f*tau_abs));
hold on;
plot((0:N-1)*fs/N, 10*log10(Yid), 'r');
La = axis;     axis([0,fs,-40, -5]);
hold off;
% ------- Parseval Theorem
E_zeit = sum(xd.^2)*Ts,     % Energie ber die Zeit
E_freq = sum(Y.^2)*fs/N,    % Energie aus der DFT-Annherung 



