% Skript fourier_reihe_rechteck_1.m, in dem die Fourier-Reihe
% eines rechteckigen Signals ermittelt wird

clear;
% ------ Initialisierungen
T0 = 1/1000;      % Periode des Signals
tast = 0.1;       % Tastverhltnis
tau = tast*T0;    % Dauer des Pulses
h = 1;            % Hhe des Pulses
%h = -1;           % Hhe des Pulses (negative Pulse)
nh = 50;          % Anzahl der Harmonischen die 
                  % berechnet werden
% ------ Ermittlung der Harmonischen
% Amplituden- und Phasenspektrum
k = 0:nh;         % Index der Harmonischen
Ak = 2*(h*tau/T0)*sinc(k*tau/T0);  
Ak(2:end) = abs(Ak(2:end));          % Amplituden
Ak(1) = abs(Ak(1))/2;                % Betrag des Mittelwerts
phik = angle((h*tau/T0)*sinc(k*tau/T0));   % Nullphasen der Harmonischen
% ------- Darstellung des Spektrums
figure(1);
subplot(211), stem(k, Ak);
title('Amplituden Ak der Harmonischen');
xlabel('Index k');    grid on;
subplot(212), stem(k, phik);
title('Nullphasen phik der Harmonischen');
xlabel('Index k');    grid on;
% ------- Zusammensetzung der harmonischen
dt = T0/1000;        % Zeitschritt
t = -T0/2:dt:T0/2;   % Zeitbereich einer Periode
nx = length(t);
%x = h*tau/T0;       % Mittelwert oder Ak(1)*sign(h)
x = Ak(1)*sign(h);
for m = 2:nh
    x = x + Ak(m)*cos((m-1)*2*pi*t/T0 + phik(m));
end;
figure(2);
plot(t,x);
title(['Zusammensetzung von ',num2str(nh),' Harmonischen']);
xlabel('Zeit in s');     grid on;
