% Skript fourier_reihe_DFT_1.m, in dem die Fourier-Reihe
% fr ein rechteckiges periodisches Signal berechnet wird 
% und mit der Annherung ber die DFT verglichen wird
clear;

% ------ Initialisierungen
T0 = 1/1000;      % Periode des Signals
tast = 0.1;       % Tastverhltnis
tau = tast*T0;    % Dauer des Pulses
h = 1;            % Hhe des Pulses
N = 256;          % Ganze Potenz von 2
%N = 64;          % Ganze Potenz von 2
nh = N-1;          % Anzahl der Harmonischen die 
                  % berechnet werden
% ------ Ermittlung der komplexen Koeffizienten 
k = 0:nh;         % Index der Harmonischen
ck = exp(-j*k*pi*tau/T0)*(h*tau/T0).*sinc(k*tau/T0);
phik = angle(ck); % Nullphasen der Harmonischen
% ------ Annherung ber die DFT
% Diskretisierung der Periode mit N Abtastwerten
x = [ones(1,round(tast*N)), zeros(1,N-round(tau*N))]; % Diskretisiertes Signal
                  % einer Periode
Xk = fft(x,N)/N;  % Angenherte Koeffizienten
% ------ Darstellung der Spektren
figure(1);  
subplot(211), stem(k, abs(ck));
title('Amplituden Spektrum');
xlabel('Index k');   grid on;
axis tight;     hold on;
stem(k, abs(Xk),'r');
legend('Komplexe Koeffizienten','DFT')
hold off;
subplot(212), stem(k, angle(ck+eps));
%subplot(212), stem(k, angle(ck));
title('Phasen Spektrum');
xlabel('Index k');   grid on;
axis tight;     hold on;
stem(k, angle(Xk));
legend('Komplexe Koeffizienten','DFT')
hold off;

