% Skript fourier_reihe2.m, in dem die 
% ein Antialiasing-Tiefpassfilter eingesetzt wird
% Funktioniert mit Modell fourier_reihe_2.slx
clear;
% -------- Parameter der Signale
xm = -10;          % Mittelwert
%xm =   0;          % Mittelwert
f1 = 100;          % Frequenz der ersten Komponente
ampl1 = 5;         % Amplitude der Komponente
phi1 = pi/3;       % Nullphase
f2 = 200;          % Frequenz der zweiten Komponente
%f2 = 200.4;         % Frequenz der zweiten Komponente
ampl2 = 12;        % Amplitude der Komponente
phi2 = pi/4;       % Nullphase
f3 = 2300;         % Frequenz der dritten Komponente
%f3 = 2300.4;         % Frequenz der dritten Komponente
ampl3 = 6;         % Amplitude der Komponente
phi3 = -pi/5;      % Nullphase
% Diskretisierung
fs = 1000;         % Abtastfrequenz
%fs = 1024;         % Abtastfrequenz
Ts = 1/fs;         % Abtastperiode
N = 1024;
% ------- Aufruf der Simulation
Tfinal = 3;
fm = max([f1,f2,f3]);    Tm = 1/fm;
dt = Tm/10;
sim('fourier_reihe_2',[0:dt:Tfinal]);
t = y.time;              % Simulationszeit
xt = y.signals.values(:,1);   % Gesamtsignal
xfilter = y.signals.values(:,2);   % Signal nach Antialiasing-TP
xabtast = y.signals.values(:,3);   % Abgetastetes Signal 
xTP_versp = y.signals.values(:,4); % Gefiltert und versptetes Signal 
xrekonst = y.signals.values(:,5);  % Aus den Abtastwerten 
                                   % rekonstruiertes Signal 
figure(1);     clf;
subplot(311), plot(t, xt);
title('Das Eingangssignal');    
xlabel('Zeit in s');      grid on;
La = axis;    axis([0.02, 0.06, La(3:4)]);
subplot(312), plot(t, xfilter, t, xabtast);
title('Das gefilterte und abgetastete Signal');
xlabel('Zeit in s');      grid on;
La = axis;    axis([0.02, 0.06, La(3:4)]);
subplot(313), plot(t, xTP_versp, t, xrekonst);
La = axis;    axis([0.02, 0.06, La(3:4)]);
title('Das gefilterte und versptete bzw. rekonstruierte Signal');    
xlabel('Zeit in s');      grid on;
% ------- Leistung des Nutzsignal
P = P(:,1,end);          % Der Block mit der zweiten FFT
figure(2);     clf;
plot((0:N-1)*fs/N, 10*log10(P),'LineWidth',1.2);
title('Spektrale Leistung des Nutzsignals in dB');
xlabel('Hz');     grid on;     axis tight;

Pm = P(1),               % Leistung wegen des Mittelwertes
Pgesamt = sum(P),        % Leistung aus der DFT
Pideal = xm^2 + ampl1^2/2 + ampl2^2/2,  % Ideale analytische Leistung

