% Skript fft_1.m, in dem die DFT (oderFFT) fr ein cosinusfrmiges
% Signal ermittelt und dargestellt wird
clear
% ------- Parameter der Simulation
T0 = 2;    % Angenommene Periode der Grundwelle
           % oder das Untersuchungsintervall
N = 64;    % Anzahl der Abtastwerte in T0
Ts = T0/N; % Abtastperiode
fs = 1/Ts; % Abtastfrequenz
ampl = 10; % Amplitude des Signals
phi = pi/3;% Nullphase bezogen auf das Untersuchungsintervall
m = 4;     % Faktor der die Periode des Signal ergibt (T0/m)
%m = 4.3;   % Faktor der zu Leakage fhrt
n = 0:N-1; % Indizes der Abtastwerte 
k = n;     % Indizes der DFT oder FFT (Bins)
% ------- Cosinusfrmiges Signal
xn = ampl*cos(2*pi*m*n/N + phi);
% ------- DFT
Xk = fft(xn);   % DFT des Signals
betrag_Xk = abs(Xk);     phase_Xk = angle(Xk);
p = find(abs(real(Xk))<1e-8 & abs(imag(Xk))<1e-8); 
phase_Xk(p) = 0;  % Entfernen der Fehler in der Phasenberechnung
% ------- Darstellungen
figure(1);
subplot(311), stem(n, xn, 'LineWidth', 1.2);
hold on; plot(n,xn);
title(['Abtastwerte des Signals (N = ',num2str(N),';  m = ',...
    num2str(m),' < N / 2)']);
xlabel('Indizes n des Signals');  grid on;  hold off;
axis tight;
subplot(312), stem(k, betrag_Xk/N);
title(['Betrag der DFT/N (N= ',num2str(N),'; m = ',...
    num2str(m),' < N / 2)']);
ylabel('|DFT|/N');   grid on;   axis tight;
subplot(313), stem(k, phase_Xk);
title(['Winkel der DFT (N= ',num2str(N),'; m = ',...
    num2str(m),' < N / 2)']);
ylabel('Rad');   grid on;  xlabel('Indizes der DFT');
axis tight;
% ------- Darstellungen mit Abszissen in s bzw. Hz
figure(2);
subplot(311), stem(n*Ts, xn, 'LineWidth', 1.2);
hold on; plot(n*Ts,xn);
title(['Abtastwerte des Signals (N = ',num2str(N),';  m = ',...
    num2str(m),' < N / 2)']);
xlabel('Zeit in s');  grid on;  hold off;
axis tight;
subplot(312), stem(k*fs/N, betrag_Xk/N);
title(['Betrag der DFT/N (N= ',num2str(N),'; m = ',...
    num2str(m),' < N / 2)']);
ylabel('|DFT|/N');   grid on;   axis tight;
subplot(313), stem(k*fs/N, phase_Xk);
title(['Winkel der DFT (N= ',num2str(N),'; m = ',...
    num2str(m),' < N / 2)']);
ylabel('Rad');   grid on;  xlabel('Hz');
axis tight;

