% Skript fenster_funkt_1.m, in dem die Fensterfunktionen
% untersucht werden
clear;
% -------- Parameter der Simulation
N = 1024;
boxcar_1 = boxcar(N);
triang_1 = triang(N);
hamming_1 = hamming(N);
hann_1 = hann(N);
chebwin_1 = chebwin(N);
blackman_1 = blackman(N);

fenster = [boxcar_1, triang_1, hamming_1, hann_1, ...
    chebwin_1,blackman_1];
Xfenster = fft(fenster,10*N);

figure(1);    clf;
subplot(321), plot(0:N-1, fenster(:,1));
title(['Boxcar-Fenster (Rechteckfenster) N = ',num2str(N)]);
xlabel('Index n');    grid on;
axis tight;
subplot(322), plot((-(10*N/2):10*N/2-1)/(10*N), 20*log10(fftshift(abs(Xfenster(:,1)))));
title('Betrag der FFT in dB');    xlabel('Relative Frequenz f/fs'); 
axis tight;   grid on;
La = axis;   axis([-0.01, 0.01, 20, La(4)])

subplot(323), plot(0:N-1, fenster(:,2));
title(['Dreieckfenster N = ',num2str(N)]);
xlabel('Index n');    grid on;
axis tight;
subplot(324), plot((-(10*N/2):10*N/2-1)/(10*N), 20*log10(fftshift(abs(Xfenster(:,2)))));
title('Betrag der FFT in dB');    xlabel('Relative Frequenz f/fs'); 
axis tight;   grid on;
La = axis;   axis([-0.01, 0.01, -20, La(4)])

subplot(325), plot(0:N-1, fenster(:,3));
title(['Hamming-Fenster N = ',num2str(N)]);
xlabel('Index n');    grid on;
axis tight;
subplot(326), plot((-(10*N/2):10*N/2-1)/(10*N), 20*log10(fftshift(abs(Xfenster(:,3)))));
title('Betrag der FFT in dB');    xlabel('Relative Frequenz f/fs'); 
axis tight;   grid on;
La = axis;   axis([-0.01, 0.01, -20, La(4)])

figure(2);    clf;
subplot(321), plot(0:N-1, fenster(:,4));
title(['Hann-Fenster N = ',num2str(N)]);
xlabel('Index n');    grid on;
axis tight;
subplot(322), plot((-(10*N/2):10*N/2-1)/(10*N), 20*log10(fftshift(abs(Xfenster(:,4)))));
title('Betrag der FFT in dB');    xlabel('Relative Frequenz f/fs'); 
axis tight;   grid on;
La = axis;   axis([-0.01, 0.01, -50, La(4)])

subplot(323), plot(0:N-1, fenster(:,5));
title(['Chebwin-Fenster N = ',num2str(N)]);
xlabel('Index n');    grid on;
axis tight;
subplot(324), plot((-(10*N/2):10*N/2-1)/(10*N), 20*log10(fftshift(abs(Xfenster(:,5)))));
title('Betrag der FFT in dB');    xlabel('Relative Frequenz f/fs'); 
axis tight;   grid on;
La = axis;   axis([-0.01, 0.01, -80, La(4)])

subplot(325), plot(0:N-1, fenster(:,6));
title(['Blackman-Fenster N = ',num2str(N)]);
xlabel('Index n');    grid on;
axis tight;
subplot(326), plot((-(10*N/2):10*N/2-1)/(10*N), 20*log10(fftshift(abs(Xfenster(:,6)))));
title('Betrag der FFT in dB');    xlabel('Relative Frequenz f/fs'); 
axis tight;   grid on;

La = axis;   axis([-0.01, 0.01, -50, La(4)])

