% Skript ad_test_3.m, in dem ein A/D-Wandler mit Hilfe 
% der FFT getestet wird.
% Arbeitet mit Modell ad_test3.slx
clear;
% -------- Parameter der Simulation
N = 4*1024;     % Anzahl Abtastwerte im Untersuchungsintervall
fs = 2*1024;      % Abtastfrequenz in Hz
Ts = 1/fs;
nperioden = 213.3; % Anzahl Perioden im Untersuchungsintervall
Tsig = N*Ts/nperioden;   % Periode des Testsignals
fsig = 1/Tsig;
ampl = 1;       % Amplitude des Testsignals
ampl1 = 1e-4;   % Amplitude der ersten Harmonischen 2*fsig
ampl2 = 1e-5;   % Amplitude der zweiten Harmonischen 3*fsig
nB = 16;        % Anzahl Bits des A/D-Wandlers
q = 2*ampl/(2^nB);   % Quantisierungsstufe
% ------- Aufruf der Simulation
Tfinal = 10;
sim('ad_test3',[0, Tfinal]);
P = Y(:,:,end);      % Spektrale Leistung
figure(1);    clf;
plot((0:N-1)*fs/N, 10*log10(P+eps));
axis tight;    La = axis;
hold on;

k1 = find(P>1e-10);     % Entfernen der Hchstwerte 
P(k1) = 0;
Pmittelwert = mean(P);  % Grundrauschen

Pgrundrausch = 10*log10(Pmittelwert);   % Geschtztes Grundrauschen in dB
plot([La(1), La(2)], [1,1]*Pgrundrausch, 'k');
SNR = -(Pgrundrausch + 10*log10(N/2));      % Signal Rauschabstand in dB
plot([La(1), La(2)], -[1,1]*SNR, 'k');
title(['Spektrale Leistung N = ',num2str(N),'; fs = ',...
    num2str(fs),'; fsig = ',num2str(fsig),'; nB = ',num2str(nB)]);
xlabel('Hz');   ylabel('Leistung in dB');   grid on;
hold off;
text(fs/3, -0.95*SNR, '6*nB+1,8');    
text(fs/3, 0.9*Pgrundrausch, 'Grundrauschen = 6*nB+1,8+10*log10(N/2)');
% -------- Effektive Anzahl von Bits
SNR,
nB = (SNR-1.8)/6, 



