% Skript abtast_rate_1.m, in dem die nderung
% der Abtastrate mit Zero-Order Hold Blcken
% untersucht wird

clear;
% -------- Parameter der Simulation
fsig = 100;   % Frequenz des Signals
ampl = 1;     % Amplitude des Signals
fs = 4000;    % Abtastfrequenz fr den Sin Wave
Ts = 1/fs;

Ts1 = 1/1000;  % Abtastperiode fr den Zero-Order Hold
fs1 = 1/Ts;
Ts2 = Ts1/4;   % Abtastperiode fr den Zero-Order Hold1
fs2 = 1/Ts1;
% -------- Aufruf der Simulation mit Continuous-Solver
Tfinal = 4/fsig;          % Dauer der Simulation   
options = simset('Solver', 'ode45');
%options = simset('Solver', 'FixedStepDiscrete');
sim('abtast_rate1', [0,Tfinal], options);

t = y.time;    % Signal des Sine Wave Blocks
y = y.data;
t1 = y1.time;  % Signal nach dem ersten Zero-Order Hold
y1 = y1.data;
t2 = y2.time;  % Signal nach dem zweiten Zero-Order Hold1
y2 = y2.data;

figure(1);    clf;
subplot(311), stem(t, y);
title('Eingangssignal (ode45 Solver)');
xlabel('Zeit in s');    grid on;
subplot(312), stem(t1,y1);
title(['Signal nach dem ersten Halteglied nullter Ordnung',...
        ' (ode45 Solver)']);
xlabel('Zeit in s');    grid on;
subplot(313), stem(t2,y2);
title(['Signal nach dem zweiten Halteglied nullter Ordnung',...
        ' (ode45 Solver)']);
xlabel('Zeit in s');    grid on;

% -------- Aufruf der Simulation mit Discret-Solver
Tfinal = 4/fsig;          % Dauer der Simulation   
options = simset('Solver', 'FixedStepDiscrete');
sim('abtast_rate2', [0,Tfinal], options);

t = y.time;    % Signal des Sine Wave Blocks
y = y.data;
t1 = y1.time;  % Signal nach dem ersten Zero-Order Hold
y1 = y1.data;
t2 = y2.time;  % Signal nach dem zweiten Zero-Order Hold1
y2 = y2.data;

figure(2);    clf;
subplot(311), stem(t, y);
title('Eingangssignal (FixedStepDiscrete Solver)');
xlabel('Zeit in s');    grid on;
subplot(312), stem(t1,y1);
title(['Signal nach dem ersten Halteglied nullter Ordnung',...
        ' (FixedStepDiscrete Solver)']);
xlabel('Zeit in s');    grid on;
subplot(313), stem(t2,y2);
title(['Signal nach dem zweiten Halteglied nullter Ordnung',...
        ' (FixedStepDiscrete Solver)']);
xlabel('Zeit in s');    grid on;


