% Skript DA_wandler_spektr_2.m, in dem das Spektrum eines 
% D/A-Wandlers untersucht wird

clear;
% -------- Parameter der Simulation
% Parameter die kein Leakage ergeben
fs = 102.4;    Ts = 1/fs;   % Abtastfrequenz und Periode
N = 1024;      % N <= nfft  % Gre des Puffers
% Parameter die Leakage ergeben
%fs = 100;      Ts = 1/fs;
%N = 1000;

p2 = nextpow2(N);           % Anzahl Sttzstellen der FFT
nfft = 2^p2;
Tblock = nfft*Ts;           % Dauer die einen Puffer fllt
% Signale
f1 = 10;          f2 = 40;  % Frequenz der Signale
ampl1 = 1;        ampl2 = 1;  % Amplituden (so kann man nur ein Signal
                              % whlen
% -------- Aufruf der Simulation
sim('DA_wandler_spektr2',[0, Tblock]);
Y = Y.signals.values(:,:,end);    % Spektrum des treppenfrmigen Ausgang
Y1 = Y1.signals.values(:,:,end);  % Spektrum der Abtastwerte
% -------- Betragsspektrum des Halteglieds nullter Ordnung
f = 0:0.1:4*fs;
H = abs(sin(pi*f*Ts+eps)./(pi*f*Ts+eps));
%H = abs(sinc(f*Ts));

figure(1);    clf;
subplot(311), plot((0:nfft-1)*fs/(nfft), 10*log10(Y1));
title('Leistungsspektrum der Abtastwerte in dB')
La = axis;    axis([La(1), fs, -80, 10]);
xlabel('Hz');     grid on;

subplot(312), plot(f, 20*log10(H));
title('Betragsspektrum des Halteglied nullter Ordnung')
La = axis;    axis([La(1), max(f), -60, La(4)]);
xlabel('Hz');     grid on; 

subplot(313), plot((0:4*nfft-1)*4*fs/(4*nfft), 10*log10(Y));
title(['Leistungsspektrum des treppenfrmigen Ausgang des',...
    ' D/A-Wandlers in dB'])
La = axis;    axis([La(1), 4*fs, -80, La(4)]);
hold on;
%plot([4*fs/2, 4*fs/2], [-80, La(4)],'r','LineWidth',2);
xlabel('Hz');     grid on;      hold off;

