%% Rundungseffekte am Beispiel der logistischen Abbildung

% Vers. 1.0 08.2016 (10/1996) 
% Copyright W.Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016
%% Berechnung der logistischen Abbildung
a=2.75:0.001:4;
x=zeros(201,length(a));
x(1,1:length(a)) = rand(1,length(a));
for n=1:200
    x(n+1,:) = a.*x(n,:).*(1-x(n,:));
end
plot(a,x(175:201,:),'pk','MarkerSize',0.5),shg

%% Rundungseffekt
% Mehrmals laufen lassen da Start mit Zufallszahl
clear,clc
aa =3.7;
y(1,1)=rand;
y(1,2)=y(1,1)
for n=1:90
    y(n+1,1) = aa.*y(n,1).*(1-y(n,1));
    y(n+1,2) = aa.*(1-y(n,2)).*y(n,2);
end
y(1,:)
y(10,:)
y(80:end,:)
    