%% Berechnung und Visualisierung exponentiell verteilter Zufallszahlen

% Vers. 1.1 08.2013 
% Copyright W.Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

% zerfall.m
clear,close all, clc
figure

subplot(1,2,1)
x = rand(1,1e07);            % gleichverteilte Zufallszahlen
hist(x,100), shg             % Histogramm
ylabel('P'),xlabel('x')
title('Normalverteilt')
subplot(1,2,2)
t = -log(x);                 % exponentiell verteilte Zufallszahlen
hist(t,100),xlim([0,6])
xlabel('t'),shg
title('Radioaktiver Zerfall')