%% Berechnung eines Integrals mittels Monte-Carlo Verfahren

% Vers. 1.1 08.2013 
% Copyright W.Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

%% Testfunktion
mcfun = @(x) sin(pi*x).*x.^2;
x = linspace(0,1);
plot(x,mcfun(x)),shg
%% Integration 
% zum Vergleich mit MC-Integration
[Q,fehler] = quadgk(mcfun,0,1)
%% Monte-Carlo Berechnung 1
tic
lang = 1e04;
xfun = (0:lang)/lang;
xmc1 = rand(1,lang+1);
ymc1 = mcfun(xfun);
tref1 = sum(xmc1<=ymc1)./length(xmc1)
fehler1 = (Q-tref1)/Q
toc
%% Monte-Carlo Berechnung 2
skal=0.4;
xmc2 = xmc1*skal;
tref2 = sum(xmc2<=ymc1)./length(xmc1)*skal
fehler2 = (Q-tref2)/Q
