function [El, Elstd,xgm] = MC_H(alpha)

% wird von MC_H augerufen 
% MC-Simulation Wasserstoffatom

% Vers. 1.1 08.2015 
% Copyright W.Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

uber = 1000;        % die ersten tausend Werte werden verworfen
for k=1:100         % Zahl der Walker
    laenge=1.e05;   % Anzahl der maximalen Schritte
    xg = 4*rand(1,laenge)/alpha;
    xtr = xg.*exp(-alpha*xg);      % Testfunktion
    gew=xtr(1:end-1)./xtr(2:end);  % Gewicht
    akz = gew>rand;                % Akzeptiert ja - nein
    r = [xg(1),xg(akz)];          
    Elr = (-1./r - 0.5*alpha*(alpha-2./r)); % lokale Energie
    gew=[1,gew(akz)];
    gew(gew>1) = 1;
    Elstd(k)=std(Elr(uber:end));
    El(k) = (Elr(uber:end)*gew(uber:end)')/sum(gew(uber:end));
    xgm(k) = max(r); 
end
El = mean(El);
Elstd = mean(Elstd);
    
    