%% Berechnung und Visualisierung Breit-Wigner verteilter Zufallszahlen

% Vers. 1.1 08.2013 
% Copyright W.Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

% BreitWigner.m
clear,close all, clc
figure

xl=0.49;
subplot(1,2,1)
x = 0.03 + 0.94*rand(1,1e07);       % gleichverteilte Zufallszahlen
hist(x,100), shg                    % Histogramm
ylabel('P'),xlabel('x')
title('Normalverteilt')
subplot(1,2,2)
min(x),max(x)
E = tan(pi*(x-1/2));                % Breit-Wigner verteilte Zufallszahlen
hist(E,100),xlim([-10,10])
xlabel({'2(E-E_R)/\Gamma'}),shg
title('Breit-Wigner')

% figure
% x = linspace(0.05,0.95);
% y = tan(pi*(x-1/2));
% plot(x,y)