%% Zerfliessen eines Gausspakets - Simulation 

% Vers. 2.1; 10.2004 
% Copyright W.Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

%% Animation
clear, close all, clc
t=0:0.2:10;   % Zeitschritte
x=-10:0.2:40; % Koordinaten
y=x;
k=0;          % Laufvariable
              % 2d-Arrays
[X,Y]=meshgrid(x,y);
              % Berechnung
%%
for T=t
   xT=X-3*T;
   yT=Y-3*T;
   Z=1./sqrt(1+4*T.^2).* ...
   exp(-2*(xT.^2+yT.^2)/(1+4*T.^2));
              % Grafik
   surf(X,Y,Z)
   shading interp
   xlim([-10 40]),ylim([-10 40])
   zlim([0 0.75])
   k=k+1;
   F(k)=getframe; % movieframes
end
              % 3 x Abspielen
movie(F,3)
%%
close
T=t(20);
   xT=X-3*T;
   yT=Y-3*T;
   Z=1./sqrt(1+4*T.^2).* ...
   exp(-2*(xT.^2+yT.^2)/(1+4*T.^2));
              % Grafik
   mesh(X,Y,Z)
   %shading interp
     xlim([-10 40]),ylim([-10 40])
   %zlim([0 0.75])