function hpoly = hermitepoly(n)

% Berechnung der Polynomkoeffizienten der Hermite-Polynome
% vgl.Gradstein&Ryshik Bd. 2
% hier: Hilfsfunktion fuer Wignerabb.m


% Vers. 1.4; 03.2013 
% Copyright W.Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

if n==0 
     hpoly = 1;
elseif n==1
     hpoly = [2 0];
else
     hpolym2 = zeros(1,n+1);
     hpolym2(n+1) = 1;
     hpolym1 = zeros(1,n+1);
     hpolym1(n) = 2;

     for k=2:n
        
         hpoly = zeros(1,n+1);

         for e=n-k+1:2:n
             hpoly(e) = 2*(hpolym1(e+1) - (k-1)*hpolym2(e));
         end
        
         hpoly(n+1) = -2*(k-1)*hpolym2(n+1);
        
         if k<n
            hpolym2 = hpolym1;
            hpolym1 = hpoly;
         end
        
     end
                
end
            