function [k1,k2,T] = pottopfres(a,V0)
% k1 Wellenzahl des "freien" Teilchens
% k2 Wellenzahl ueber dem Potenzial
% T Transmissionskoefizient
% a Potentialbreite V0 Potentialtiefe
% typischer Aufruf [k1,k2,T] = pottopfres(1,1);

% Copyright W. Schweizer 2013-2016
% Vers. 1.2

% Copyright W.Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

E = linspace(0.1,20,10000);
%a=1.;
%V0=1;

k1=sqrt(2*E);
k2=sqrt(2*(E+V0));
T = 4*k1.^2.*k2.^2./(4*k1.^2.*k2.^2 +((k1.^2-k2.^2).*sin(2*a*k2)).^2);
x = 2*a*k2;
plot(x,T),shg
hold on
if a==1 && V0==1
plot([pi,pi],[0.93,1],'k',[2*pi,2*pi],[0.93,1],'k',[3*pi,3*pi],[0.93,1],'k',[4*pi,4*pi],[0.93,1],'k')
end
ylabel('T'),xlabel('2 a k_2')
hold off
