function varargout = pottopf(varargin)
% POTTOPF MATLAB code for pottopf.fig
%      POTTOPF, by itself, creates a new POTTOPF or raises the existing
%      singleton*.
%
%      H = POTTOPF returns the handle to a new POTTOPF or the handle to
%      the existing singleton*.
%
%      POTTOPF('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in POTTOPF.M with the given input arguments.
%
%      POTTOPF('Property','Value',...) creates a new POTTOPF or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before pottopf_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to pottopf_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help pottopf

% Last Modified by GUIDE v2.5 04-May-2013 14:54:02

% W.Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @pottopf_OpeningFcn, ...
                   'gui_OutputFcn',  @pottopf_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before pottopf is made visible.
function pottopf_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to pottopf (see VARARGIN)

% Choose default command line output for pottopf
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes pottopf wait for user response (see UIRESUME)
% uiwait(handles.figure1);


handles.hpot=plot([-2.5,-1],[0,0],'k',[-1,1],[-1,-1],'k',[1,2.5],[0,0],'k',[-1,-1],[0,-1],'k',[1,1],[0,-1],'k');
xlim([-3,3])
ylim([-1.2,0.2])
xlabel('a')
ylabel('V')
set(get(handles.achsen,'Xlabel'),'Position',[0.515 -1.257165839 1.00011])
hold on
a=get(handles.aslider,'Value');
V=get(handles.Vslider,'Value');
pottopfeig(a,V,handles)

%Position = [-0.0133038 -1.65839 1.00011]
guidata(hObject, handles);

% --- Outputs from this function are returned to the command line.
function varargout = pottopf_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on slider movement.
function aslider_Callback(hObject, eventdata, handles)
% hObject    handle to aslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

a=round(100*get(handles.aslider,'Value'))/100;
set(handles.aslider,'Value',a)

set(handles.atxt,'String',['Breite a = ',num2str(a)]) 
set(handles.hpot(1),'Xdata',[-3*a,-a])
set(handles.hpot(2),'Xdata',[-a,a])
set(handles.hpot(3),'Xdata',[a,3*a])
set(handles.hpot(4),'Xdata',[-a,-a])
set(handles.hpot(5),'Xdata',[a,a])
xlim([-3*a,3*a])
Vt=get(handles.Vslider,'Value');
set(get(handles.achsen,'Xlabel'),'Position',[a/3 Vt*1.25 1.00011])
%handles
heig=get(handles.figure1,'UserData');
delete(heig)
%handles
pottopfeig(a,Vt,handles)


% --- Executes during object creation, after setting all properties.
function aslider_CreateFcn(hObject, eventdata, handles)
% hObject    handle to aslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function Vslider_Callback(hObject, eventdata, handles)
% hObject    handle to Vslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

Vt=get(handles.Vslider,'Value');
if Vt < -0.011
    Vt = round(10*Vt)/10;
end
set(handles.Vslider,'Value',Vt)
set(handles.text2,'String',['V = ',num2str(Vt)]) 
set(handles.hpot(2),'Ydata',[Vt,Vt])
set(handles.hpot(4),'Ydata',[Vt,0])
set(handles.hpot(5),'Ydata',[Vt,0])
ylim([Vt*1.2,-Vt/5])
a=get(handles.aslider,'Value');
set(get(handles.achsen,'Xlabel'),'Position',[a/3 Vt*1.25 1.00011])
heig=get(handles.figure1,'UserData');
delete(heig)
%handles
pottopfeig(a,Vt,handles)


% --- Executes during object creation, after setting all properties.
function Vslider_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Vslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


function pottopfeig(a,V0,handles)
% clear,clc
% %
% V0=1.00; %100
% a=10;
a;
V0=-V0;
sfun = @(x) tan(sqrt(2*(x+V0))*a)-sqrt(-x./(x+V0)); 
afun = @(x) tan(sqrt(2*(x+V0))*a)+sqrt(-(x+V0)./x); 
%

E=linspace(-V0,0,1000);
phi = sqrt(2*(E+V0))*a;
z1 = sqrt(-E./(E+V0));
z2 = -1./z1;

% figure
% plot(phi,tan(phi),'m')
% hold on
% plot(phi,z1,phi,z2)
% shg
% hold off

n=ceil(2*sqrt(2*V0)*a/pi);
nsym = ceil(n/2);
nanti = n-nsym;

Esym=zeros(1,nsym);
fvals = Esym;

for k=1:nsym
    phig = [0,pi/2]+(k-1)*pi;
    x0 = ((phig./a).^2)./2-V0;
    if x0(1) == -V0
        x0(1) = x0(1)+V0/10000;
    end
    if x0(2)>0
        x0(2)=-eps;
    end
    dx = x0(1)-x0(2);
    while abs(sfun(x0(1))) > 10000 || abs(sfun(x0(2))) > 10000
            xt = linspace(x0(1),x0(2));
            [w,ind]=max(abs(afun(xt)));
            xt(ind) = [];
            x0(1)=xt(1);
            x0(2)=xt(end);
    end
    [Esym(k),fvals(k),exitflag,output] = fzero(sfun,x0);
    if exitflag ~= 1
        xtest = linspace(xt(1),xt(2));
        figure, plot(xtest,sfun(xtest)), shg
    end
end
if nanti > 0
    Eant = zeros(1,nanti);
    fvala = Eant;
    for k =1:nanti
        phig = [pi/2+eps, pi] + (k-1)*pi;
        x0 = ((phig./a).^2)./2-V0;
        if x0(2)>0
            x0(2)=-eps;
        end
        while abs(afun(x0(1))) > 10000 || abs(afun(x0(2))) > 10000
            xt = linspace(x0(1),x0(2));
            [w,ind]=max(abs(afun(xt)));
            xt(ind) = [];
            x0(1)=xt(1);
            x0(2)=xt(end);
        end
%         while afun(x0(1))*afun(x0(2)) >=0
%         xv = x0(2);
%         x0(1)=x0(2);
%         x0(2)=x0(2)-dx/2;
%         end
        [Eant(k),fvala(k),exitflag,output] = fzero(afun,x0);
    end
end
if nanti >0
    Eres = sort([Esym,Eant]);
else
    Eres = Esym;
end

%sfun = @(x) tan(sqrt(2*(x+V0))*a)-sqrt(-x./(x+V0)); 
%afun = @(x) tan(sqrt(2*(x+V0))*a)+sqrt(-(x+V0)./x); 

% figure
% h=plot([-2.5,-1],[0,0],'k',[-1,1],[-1,-1],[1,2.5],[0,0],'k',[-1,-1],[0,-1],'k',[1,1],[0,-1],'k')
% xlim([-3,3])
% ylim([-1.5,0.5])
% shg
% hold on
aplot=repmat([-0.99*a;0.99*a],1,length(Eres));
Eplot=repmat(Eres,2,1);
heig=plot(aplot,Eplot);
handles;
set(handles.figure1,'UserData',heig)
%guidata(hObject, handles);

title({'Eigenzustände';['symmetrische: ', num2str(nsym),' antisym. ', num2str(nanti)]})


%get(heig(1),'Ydata');
dcm=datacursormode;
set(dcm,'Enable','on')
set(dcm,'UpdateFcn',@NC)

function output_txt = NC(obj,event_obj)
% Display the position of the data cursor
% obj          Currently not used (empty)
% event_obj    Handle to event object
% output_txt   Data cursor text string (string or cell array of strings).

pos = get(event_obj,'Position');
output_txt = {['Energie: ',num2str(pos(2),4)]};

% If there is a Z-coordinate in the position, display it as well
if length(pos) > 2
    output_txt{end+1} = ['Z: ',num2str(pos(3),4)];
end


