% Zusatzbeispiel zur Objekt-Orientierten Programmierung
% Berechnung der Hermite-Polynome

% W. Schweizer
% 08/2006 - 01/2013
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016


classdef hermiteoop < meinpoly
    properties
        info
    end
    methods
        function obj = hermiteoop(n)

            if n==0 
                hpoly = 1;
            elseif n==1
                hpoly = [2 0];
            else
    
                hpolym2 = zeros(1,n+1);
                hpolym2(n+1) = 1;
                hpolym1 = zeros(1,n+1);
                hpolym1(n) = 2;

                for k=2:n
        
                    hpoly = zeros(1,n+1);

                    for e=n-k+1:2:n
                        hpoly(e) = 2*(hpolym1(e+1) - (k-1)*hpolym2(e));
                    end
        
                    hpoly(n+1) = -2*(k-1)*hpolym2(n+1);
        
                if k<n
                    hpolym2 = hpolym1;
                    hpolym1 = hpoly;
                end
        
                end
    
            end
            %obj.coef=hpoly;
            obj=obj@meinpoly(hpoly);
            obj.info=['Hermite-Polynom ',num2str(n),'-ter Ordnung'];
        end
    end
end
% Sonst noch interessant
% Bernoulli numbers
% Euler numbers
% Chebyshev, Laguerre, and Hermite polynomials
% Gauss-Legendre quadrature
% Gauss-Laguerre
% Gauss-Hermite
% gamma function.
% logarithm of the gamma function.
% gamma function with a complex argument.
% beta function.
% psi function.
% psi function with a complex argument.
% incomplete gamma function.
% incomplete beta function.
% Legendre polynomials
% Legendre functions of the second kind
% associated Legendre polynomials
% Bessel functions of the first and second kinds
% zeros of the Bessel functions of the first and second kinds
% lambda functions
% modified Bessel functions of the first and second kinds
% Hankel functions of the first and second kinds
% integral of Bessel functions J0(t) and Y0(t) from 0 to x
% integral of [1-J0(t)]/t from 0 to x and Y0(t)/t from x to infinity
% integral of modified Bessel functions I0(t) and K0(t) from 0 to x
% integral of [1-I0(t)]/t from 0 to x and K0(t) from x to infinity
% spherical Bessel functions of the first and second kinds
% Riccati-Bessel functions of the first kind and second kind
% modified spherical Bessel functions of the first kind and second kind
% Kelvin functions
% zeros of the Kelvin functions
% Airy functions
% integral of the Airy functions.
% zeros of Airy functions
% Struve functions with an arbitrary order
% integral of Struve function H0(t) from 0 to x.
% integral of H0(t)/t from x to infinity.
% modified Struve function with an arbitrary order.
% integral of modified Struve function L0(t) from 0 to x.
% hypergeometric function
% hypergeometric function M(a,b,z)
% hypergeometric function U(a,b,x)
% parabolic cylinder functions Dv(z)
% parabolic cylinder functions Vv(x)
% parabolic cylinder functions W(a,+/-x)
% characteristic values for the Mathieu and modified Mathieu functions.
% expansion coefficients for the Mathieu and modified Mathieu functions.
% Mathieu functions
% modified Mathieu functions of the first and second kinds
% characteristic values for spheroidal wave functions.
% angular spheroidal wave functions
% radial spheroidal wave functions
% error function.
% Fresnel Integrals.
% modified Fresnel integrals.
% complex zeros of the error function.
% complex zeros of the Fresnel Integrals.
% cosine and sine integrals
% complete and incomplete elliptic integrals of the first and second kinds.
% complete and incomplete elliptic integrals of the third kind.
% Jacobian elliptic functions.
% exponential integral E1(x)
% exponential integrals En(x)
% exponential integral Ei(x) 
%  
%      
