%% Visualisierung der Eigenfunktionen des harmonischen Oszillators

% Vers. 1.; 04.2013 
% Copyright W.Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

clear, close all, clc
%% Potential plotten
figure
x = linspace(-3.15,3.15);
V = 0.5 .* x.^2;
plot(x,V,'k','LineWidth',1.5), shg
hold on
%%
for k=1:5
    y = k-0.5;
    x = sqrt(2*y);
    plot([-x,x],[y,y],'k','LineWidth',1)
    [xe,we]=harmonosceigen(k-1);
    wemax = max(abs(we));
    we = we/(4*wemax)+y;
    plot(xe,we,'k--','LineWidth',1)
end
plot([0,0],[0,V(end)],'k')