% Visualisierung der radialen Wellenfuktion des sphaerischen harmonischen Oszillators
% Vers. 1. 12/2011
%
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

frexp = @(r) exp(-0.5.*r.^2);
%
nrk = [0,1,2];
lk  = [0,1,2];
[nrk,lk] = meshgrid(nrk,lk);
for k = 1:9
    nr = nrk(k);
    l = lk(k);
    lpoly=laguerrepolyfun(nr,l);
    r = linspace(0,5);
    y = r.^l.*frexp(r).*polyval(lpoly,r.^2);
    subplot(3,3,k)
    plot(r,y,'k','Linewidth',1), hold on, plot([0,5],[0,0],'k'),shg
end
%
