function [x,wellfunho]=harmosceigen(n)

% Berechnung der Eigenfunktionen des harmonischen Oszillators
% sqrt(hbar/m omega) = 1

% Vers. 1; 03.2013 
% Copyright W.Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

x = linspace(-4,4,2000); % normierte Ortskoordinate
nfak = 1/sqrt(sqrt(pi)*2^n*factorial(n));
Hn = polyval(hermitpoly(n),x);
wellfunho = nfak*Hn.*exp(-1/2*x.^2);

% Visualisierung
% plot(x,wellfunho),grid on,shg
