% vgl. Matlab Kompakt 6. Auflage 
% W. Schweizer
% 08/2006 - 01/2016
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016
function plot(obj,varargin)
if ~isa(obj,'meinpoly')
    error('Mit den Inputargumenten stimmt was nicht: 1. Argument Objekt der Klasse meinpoly')
end
%   Eigentliche Berechnung
    cf =obj.coef;
    if nargin == 1
        grenzen = real(roots(cf));
        if isempty(grenzen) || min(grenzen)==max(grenzen)
            grenzen = [-2,2];
        end
        x=linspace(grenzen(1),grenzen(2));
    elseif nargin == 2
        x=varargin{1};
    elseif nargin == 3
        x=linspace(varargin{1},varargin{2});
    else
        error('Mit den Inputargumenten stimmt was nicht: 1. Argument Objekt der Klasse meinpoly')
    end
    y=polyval(cf,x);
    % Plotten
    plot(x,y),grid on, shg
    ylabel('Polynomwerte')
    title(['Polynomplot f�r  ',...
      polydar(obj)])