% vgl. Matlab Kompakt 6. Auflage 
% W. Schweizer
% 08/2006 - 01/2016
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016


function erg = mult(p1,p2)

% p1 und p2 zu Multiplizierende Polynome
% Gesamte Ordnung
if isa(p1,'numeric') || isa(p2,'numeric')
    p1=meinpoly(p1);
    p2=meinpoly(p2);
    disp('Achtung ein Argument vom Typ numeric')
end
if ~isa(p1,'meinpoly') && ~isa(p2,'meinpoly')
    error('Input vom falschen Typ')
end

p1=p1.coef;
p2=p2.coef;
no = length(p1)+length(p2)-1;
n = 0:no-1;
% Berechnung der Einheitswurzeln
ewurz = exp(2*pi*i*n/no);
% Auswertung der Polynome an den Einheitswurzeln

p1w = polyval(p1,ewurz);
p2w = polyval(p2,ewurz);

% Multiplikation

pw = p1w.*p2w;

% Berechnung der Koeffizienten
pcoeff = ifft(pw);
erg = round([pcoeff(2:end) pcoeff(1)]*1e10)/1e10;

% Vergleichstest

%test = conv(p1,p2);
erg = meinpoly(erg);
