function y=dlmm(l,m,ms,theta)
% Berechnung der Funktion d^l_mm'
% Nutzt zur Berechnung Jacobi-Polynome
% Bsp.: beta = linspace(0,2*pi);
%       y = dlmm(3,2,0,beta);  % l=3, m= 2, m'=0

% Vers. 1.0; 08.2016 
% Copyright W.Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

if (abs(m) > l || abs(ms) > l)
    disp('unzulaessige Werte')
    y = [l,m,ms];
else
    x = cos(theta);
    n = l-m;
    alpha = m-ms;
    beta = m+ms;
    Ps = JacobiPolRek(n,alpha,beta,x);

    Vorf = sqrt(factorial(l+m).*factorial(l-m)./(factorial(l-ms).*factorial(l+ms)));
    b2 = theta/2;
    Erg = Vorf.*cos(b2).^(m+ms).*sin(b2).^(m-ms).*Ps.P(end,:);
    
    y.l=l;
    y.m_ms=[m,ms];
    y.beta=theta;
    y.dlmms = Erg;
end
    