%% Visualisierung der Kugelflaechenfunktionen l=2

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

% Vers. 1.1 08/2016

%% Berechnungen
%m = abs(m);
theta = linspace(0,2*pi,100);
phi   = linspace(0,2*pi,100);
[Theta,Phi] = meshgrid(theta,phi);   % Winkel zur Visualisierung
x = cos(Theta);
l = 2;
y3 = legendre(l,x);                  % Assoziertes Legendre-Polynom
for m = 0:l
    k=m+1;
    yphi = (-1)^m * sqrt((2*l+1)*factorial(l-m)/(4*pi*factorial(l+m))).*exp(i*m*Phi);
    eval(['Y_',num2str(l),num2str(m),' = ','squeeze(y3(k,:,:)).*yphi;']);
end
%% Visualisierung
X0 = abs(Y_20).*cos(Phi).*sin(Theta);
Y0 = abs(Y_20).*sin(Phi).*sin(Theta);
Z0 = abs(Y_20).*cos(Theta);
figure,surf(X0,Y0,Z0),title('m = 0'), zlim([-0.65,0.65]),shg
%
X1 = abs(Y_21).*cos(Phi).*sin(Theta);
Y1 = abs(Y_21).*sin(Phi).*sin(Theta);
Z1 = abs(Y_21).*cos(Theta);
figure,surf(X1,Y1,Z1),title('m = 1'),shg
%
X2 = abs(Y_22).*cos(Phi).*sin(Theta);
Y2 = abs(Y_22).*sin(Phi).*sin(Theta);
Z2 = abs(Y_22).*cos(Theta);
figure,surf(X2,Y2,Z2),title('m = 2'),shg
%% Buch-Abbildung
% Camera Toolbar (View) Light etc nutzen
grau= [0.8 0.8 0.8;0.85 0.85 0.85;0.9 0.9 0.9];
figure
subplot(1,3,1)
mesh(X0,Y0,Z0),axis off, colormap(grau)
title('m=0','FontSize',14)
%
subplot(1,3,2)
mesh(X1,Y1,Z1),axis off, colormap(grau)
title('m=1','FontSize',14)
%
subplot(1,3,3)
mesh(X2,Y2,Z2),axis off, colormap(grau)
title('m=2','FontSize',14)
%
