%% Visualisierung verschiedener Magnetsysteme

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

% Vers. 2.1 12/2014

%% 
x = linspace(-2,2,100);
y = x;
[X,Y] = meshgrid(x,y);
%% Dipol
figure
Bxd = zeros(size(X));
Byd = ones(size(Y));
quiver(X(1:4:end,1:4:end),Y(1:4:end,1:4:end),Bxd(1:4:end,1:4:end),Byd(1:4:end,1:4:end),1,'k'),shg
%% Quadrupol
figure
Bxq= Y;
Byq = X;
quiver(X,Y,Bxq,Byq,1,'k'),shg
hold on,
contour(X,Y,Bxq),shg

Polfun = X.*Y;
figure,
contour(X,Y,Polfun,25)
hold on
quiver(X(1:4:end,1:4:end),Y(1:4:end,1:4:end),Bxq(1:4:end,1:4:end),Byq(1:4:end,1:4:end),1,'k'),shg
%% Sextopol
figure
Bxs= X.*Y;
Bys = 1/2*(X.^2-Y.^2);
quiver(X,Y,Bxs,Bys,1,'k')
hold on
contour(X,Y,Bxs,25),shg
figure
quiver(X,Y,Bxs,Bys,1,'k')
hold on
contour(X,Y,Bys,25),shg
hold off
figure
Polfuns = (3*X.^2.*Y - Y.^3)/6;
contour(x,y,Polfuns,25);
hold on
quiver(X(1:4:end,1:4:end),Y(1:4:end,1:4:end),Bxs(1:4:end,1:4:end),Bys(1:4:end,1:4:end),1,'k'),shg
%%
figure, axis off
subplot(1,3,1)
quiver(X(1:8:end,1:8:end),Y(1:8:end,1:8:end),Bxd(1:8:end,1:8:end),Byd(1:8:end,1:8:end),0.5,'k'), shg
xlim([-2,2]),ylim([-2,2])
title('Dipol')
%
subplot(1,3,2)
Polfun = X.*Y;
contour(X,Y,Polfun,25)
hold on
quiver(X(1:6:end,1:6:end),Y(1:6:end,1:6:end),Bxq(1:6:end,1:6:end),Byq(1:6:end,1:6:end),2,'k'),shg
xlim([-2,2]),ylim([-2,2])
title('Quadrupol')
%
subplot(1,3,3)
Polfuns = (3*X.^2.*Y - Y.^3)/6;
contour(x,y,Polfuns,25);
hold on
quiver(X(1:6:end,1:6:end),Y(1:6:end,1:6:end),Bxs(1:6:end,1:6:end),Bys(1:6:end,1:6:end),2,'k'),shg
xlim([-2,2]),ylim([-2,2])
title('Sextopol')