function dy = konstMagnquadEfeldDGL(t,y,qm,B0,Ur)
% Differentialgleichung: Penning-Falle
% Magnetfeld konstant z-Richtung
% elektrisches Quadrupolmoment

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

% Vers. 1.2 11/2014

dy(1) = y(4);
dy(2) = y(5);
dy(3) = y(6);
dy(4) = qm*(B0*y(5) - Ur*y(1)); 
dy(5) = -qm*(B0*y(4) -Ur*y(2));
dy(6) = qm*Ur*2*y(3);          

dy = dy.';