function dy = konstMagnDGL(t,y,qm,B0,Ex,Ez)
% Differentialgleichung zu Bewegung im konstantene E-B-Feld

% wird von konstMagn.m und BewegungBuEFeld.m aufgerufen

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

% Vers. 1.2 11/2014

dy(1) = y(4);
dy(2) = y(5);
dy(3) = y(6);
dy(4) = qm*(B0*y(5)-Ex); % + E-Feld in x-Richtung
dy(5) = -qm*B0*y(4);
dy(6) = -qm*Ez;          % + E-Feld in z-Richtung

dy = dy.';