%% Visualisierung der Bewegung eines Ions in einem konstanten elektrischen und magnetischen Feld

% Aufruf:  konstMagnDGL(t,y,qm,B0,Ex,Ey)
% B0 Magnetfeld in z-Richtung in Tesla
% Ex, Ez elektrisches Feld in V/m
% qm = q/m in As/kg q Ladung; m Masse

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

% Vers. 1.2 11/2014

tmax = 3e-06;%-06;                    % Integrationsdauer
y0 = [0;0;0;100;100;100];             % Anfangswerte in 
                                      % x-y-z Richtung (hier 0;0;0)
                                      % Geschwindigkeiten vx-vy-vz (hier
                                      % 100;100;100)
qe = 1.602e-19;                       % C Elementarladung des Elektrons 
me = 9.1096e-31;                      % Masse des Elektrons
m = 1836*me*12;                       % Masse C-12 (5-fach ionisiert)
qm = qe/m;
B0 = 3.7;                             % Magnetfeld in T (z-Richtung)
E0= 0;-7.5;%e03;%0;                   % Betrag elektrisches Feld V/m
wi = pi/2;                            % Richtung: Parallele Felder wi=0; senkrecht wi=pi/2;
Ez = E0 * cos(wi);
Ex = E0 * sin(wi);

tic
[t,y] = ode15s(@(t,y) konstMagnDGL(t,y,qm,B0,Ex,Ez),[0,tmax],y0);
toc

%% Visualisierung
plot3(y(:,1),y(:,2),y(:,3))
xlabel('x'),ylabel('y'),zlabel('z'), shg
