%% Influenz: Elektrisches Feld und Gesamtladung
%

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

% Vers. 1.1 10/2010-15


%% Elektrisches Feld
% Im Abstand a befindet sich eine Punktladung vor einer ausgedehnten
% metallischen Platte. Das elektrische Feld kann mit dem Verfahren der 
% Bildladung bzw. Spiegelladung berechnet werden.

clear, close, clc % loeschen aller Daten und Abbildungen 
%tic               % Neugierde: Messen der Berechnungszeit

%% Plotten des elektrischen Felds auf der Metallplatte
n = 100;                % Anzahl der Gitterpunkte
% Erstellen des Gitters
y = linspace(-2,2,n);   
z = y;
[Y,Z] = meshgrid(y,z);

% Berechnen des Elektrischen Felds
Etilde = 1./sqrt(1 + Y.^2 + Z.^2).^3;
% Plotten
surf(Y,Z,Etilde), shading interp 
xlabel('Y'), ylabel('Z'), zlabel('E')
% "shading bestimmt die Oberflaechenstruktur und erlaubt die Werte 
% flat, faceted (Default) und interp
%toc misst die Berechnungsdauer

%% Berechnen der Gesamtladung qint
% MATLAB bietet mehrere Funktionen zur Berechnung eines Integrals an
% Hier kann das Problem auf eine eindimensionale Integration zurückgeführt
% werden.

% 1. Schritt: Ueber welche Funktion soll integriert werden
% Dazu nutzen wir eine anonyme Funktion
% Die Syntax ist fhandle = @(argliste) Funktion
% fhandle ist ein "Function Handle"
% argliste eine kommaseparierte Liste der Funktionsargumente
% Funktion die eigentlich Funktion

% Anonyme Funktionen sollten nur für einfache Funktionen verwandt werden.
% Wir werden spaeter noch weitere Konzepte sehen

% 2. Schritt: Festlegung der Grenzen ueber die Integriert werden soll
%             Hier von 0 bis unendlich

qint = @(rho) 1./(1+rho.^2).^(3/2);  % anonyme Funktion
% Diese Funktion ist fuer 0 ... unendlich auch exakt loesbar und ergibt 1

[Q, Fehler] = quadgk(qint,0,inf);

% Ausgabe des Ergebnis: disp oder etwas anspruchsvoller fprintf
formatSpec = 'Die Gesamtladung ist -q * %1.4f und der Berechnungsfehler %1.4e\n';
fprintf(formatSpec,Q,Fehler)

% vgl. auch >> doc quadgk
