%% Elektrostatisches Potential und elektrisches Feld eines Plattenkondensators

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

% Vers. 3.0 10/2010-15

%
%% Betrachtet wird ein zirkularer Plattenkondensator
% Parameter:
a = 1;    % Radius der zirkularen Platte (bestimmt letzlich die Kapazitaet
d = 1;    % Plattenabstand
V = 100;  % Spannung zwischen den Platten

%% Erstellen des Gitters

x = -2:0.1:2;
y = -2:0.1:2;
[X, Y] = meshgrid(x, y);
figure
axis([-2 2 -2 2])

%% Elektrostatisches Potential (Approximation):
PHI= (2*V/pi)* ...
     (asin(2*a./(sqrt((Y-d/2).^2 + (X-a).^2) + sqrt((Y-d/2).^2 + (X+a).^2))) ...
    - asin(2*a./(sqrt((Y+d/2).^2 + (X-a).^2) + sqrt((Y+d/2).^2 + (X+a).^2))));

%% Plot der Aequipotentiallinien:
% X,Y Ortskoordinaten, PHI elektrostatisches Potential an den Gitterpunkten
% "20" Anzahl der Aequipotentiallinien
contour(X, Y, PHI, 20, 'LineWidth', 2)
hold on        % schuetzt die Abbildung vor loeschen

%% Berechnen und Plotten des elektrischen Feld

[Ex, Ey] = gradient(PHI, 0.1);   % "0.1" Ortsaufloesung
quiver(X, Y, Ex, Ey, 1, 'k')     % "1" ist ein Skalierungsfaktor, 
                                 % damit die Pfeile nicht ueberlappen
                                 % 'k': schwarz

% Plotten des Kondensators:
line('XData', [-a a],'YData', [d/2, d/2], 'Color', 'b', 'LineWidth', 3)
line('XData', [0 0],'YData', [d/2, 3], 'Color', 'b', 'LineWidth', 3)
line('XData', [-a a],'YData', [-d/2, -d/2], 'Color', 'r', 'LineWidth', 3)
line('XData', [0 0],'YData', [-3, -d/2], 'Color', 'r', 'LineWidth', 3)
