function dy = MagnetoptikSextupolDgl(t,y,qB0m,qB0fm,v0,xcorr,zcorr)
% Differentialgleichung fuer Dipol-Sextupol System
% Magnet kann ich sich an beliebiger Stelle im Beschleuniger (x-z-Ebene) befinden
% Korrektur xcorr,zcorr

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

% Vers. 2.1 01/2015

% qB0m Sextupol
% qB0fm Dipol

dy(1) = y(4);
dy(2) = y(5);
dy(3) = y(6);
yc(1) = y(1)-xcorr;
yc(2) = 0;
yc(3) = y(3)-zcorr;
dy(4) = (-qB0fm-1/2*qB0m*(yc(1).^2-y(2).^2))*y(6);
dy(5) = qB0m*yc(1)*y(2)*y(6);
dy(6) = -1/2*qB0m*(2*yc(1)*y(2)*y(5)+(y(2).^2 - yc(1).^2) * y(4)) + qB0fm*y(4);       

dy = dy.';