%% Lorentztransformation

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

% Vers. 1.1 03/2016

syms alpha
Lx = [cosh(alpha) sinh(alpha) 0 0; ...
      sinh(alpha) cosh(alpha) 0 0; ...
           0           0      1 0; ...
           0           0      0 1];   % Lorentz-Boost x-Richtung

syms Ex Ey Ez Bx By Bz c
F  = [0   -Ex   -Ey    -Ez ; ...
      Ex   0   -c*Bz   c*By; ...
      Ey  c*Bz    0   -c*Bx; ...
      Ez -c*By  c*Bx     0 ];       

syms Ft Ext Eyt Ezt Bxt Byt Bzt

Ft = simplify(Lx*F*Lx);
Ext = Ft(2,1)
Eyt = Ft(3,1)
Ezt = Ft(4,1)
Bxt = simplify(Ft(4,3)/c)
Byt = simplify(Ft(2,4)/c)
Bzt = simplify(Ft(3,2)/c)
%%
Bztfun = matlabFunction(Bzt)    % Wandeln in MATLAB function handle
beta = linspace(0,0.99); c = 1;
alpha = atanh(-beta);
% keine Magnetfelder
y = Bztfun(0,1,alpha,c);
plot(beta,y)
