function varargout = BewegungBuEFeld(varargin)
% BEWEGUNGBUEFELD MATLAB code for BewegungBuEFeld.fig
%      BEWEGUNGBUEFELD, by itself, creates a new BEWEGUNGBUEFELD or raises the existing
%      singleton*.
%
%      H = BEWEGUNGBUEFELD returns the handle to a new BEWEGUNGBUEFELD or the handle to
%      the existing singleton*.
%
%      BEWEGUNGBUEFELD('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in BEWEGUNGBUEFELD.M with the given input arguments.
%
%      BEWEGUNGBUEFELD('Property','Value',...) creates a new BEWEGUNGBUEFELD or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before BewegungBuEFeld_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to BewegungBuEFeld_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help BewegungBuEFeld

% Last Modified by GUIDE v2.5 05-Nov-2016 14:27:37


% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @BewegungBuEFeld_OpeningFcn, ...
                   'gui_OutputFcn',  @BewegungBuEFeld_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before BewegungBuEFeld is made visible.
function BewegungBuEFeld_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to BewegungBuEFeld (see VARARGIN)

% Choose default command line output for BewegungBuEFeld
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes BewegungBuEFeld wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = BewegungBuEFeld_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on slider movement.
function Bslider_Callback(hObject, eventdata, handles)
% hObject    handle to Bslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

B0 = get(handles.Bslider,'Value');
Anzeige = ['B-Feld ',num2str(B0,3), ' T'];
set(handles.Btxt,'String',Anzeige);

E0 = get(handles.Eslider,'Value');
w = get(handles.Richtslider,'Value');
wi = w/180*pi;

Zeit = get(handles.edit1,'String');

    Zeit(strfind(Zeit,'s')) =[];
    tmax = str2num(Zeit);
if isempty(tmax)
    disp('Falsche Eingabe t max')
    disp('entweder nur Zahl oder gefolgt bei s')
    disp('typischer Wert 3e-06 s')
end

x0 = get(handles.Ortedt,'String');
    x0 = str2num(x0);
    
v0 = get(handles.edit3,'String');
    v0 = str2num(v0);
    
konstMagn(B0,E0,wi,tmax,x0,v0)

% --- Executes during object creation, after setting all properties.
function Bslider_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Bslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function Eslider_Callback(hObject, eventdata, handles)
% hObject    handle to Eslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

E0 = get(handles.Eslider,'Value');
Anzeige = ['E-Feld ',num2str(E0,3), ' V/m']
set(handles.Etxt,'String',Anzeige)


B0 = get(handles.Bslider,'Value');
w = get(handles.Richtslider,'Value');
wi = w/180*pi;

Zeit = get(handles.edit1,'String');

    Zeit(strfind(Zeit,'s')) =[];
    tmax = str2num(Zeit);
if isempty(tmax)
    disp('Falsche Eingabe t max')
    disp('entweder nur Zahl oder gefolgt bei s')
    disp('typischer Wert 3e-06 s')
end

x0 = get(handles.Ortedt,'String');
    x0 = str2num(x0);
    
v0 = get(handles.edit3,'String');
    v0 = str2num(v0);
    
konstMagn(B0,E0,wi,tmax,x0,v0)

% --- Executes during object creation, after setting all properties.
function Eslider_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Eslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function Richtslider_Callback(hObject, eventdata, handles)
% hObject    handle to Richtslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

w = get(handles.Richtslider,'Value');
Anzeige = ['Richting ',num2str(w,3)];
set(handles.Richttxt,'String',Anzeige)
wi = w/180*pi;


E0 = get(handles.Eslider,'Value');
B0 = get(handles.Bslider,'Value');

Zeit = get(handles.edit1,'String');

    Zeit(strfind(Zeit,'s')) =[];
    tmax = str2num(Zeit);
if isempty(tmax)
    disp('Falsche Eingabe t max')
    disp('entweder nur Zahl oder gefolgt bei s')
    disp('typischer Wert 3e-06 s')
end

x0 = get(handles.Ortedt,'String');
    x0 = str2num(x0);
    
v0 = get(handles.edit3,'String');
    v0 = str2num(v0);
    
konstMagn(B0,E0,wi,tmax,x0,v0)

% --- Executes during object creation, after setting all properties.
function Richtslider_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Richtslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end



function edit1_Callback(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit1 as text
%        str2double(get(hObject,'String')) returns contents of edit1 as a double

Zeit = get(handles.edit1,'String')

    Zeit(strfind(Zeit,'s')) =[];
    tmax = str2num(Zeit);
if isempty(tmax)
    disp('Falsche Eingabe')
    disp('entweder nur Zahl oder gefolgt bei s')
    disp('typischer Wert 3e-06 s')
end


B0 = get(handles.Bslider,'Value');

E0 = get(handles.Eslider,'Value');
w = get(handles.Richtslider,'Value');
wi = w/180*pi;

x0 = get(handles.Ortedt,'String');
    x0 = str2num(x0);
    
v0 = get(handles.edit3,'String');
    v0 = str2num(v0);
    
konstMagn(B0,E0,wi,tmax,x0,v0)

% --- Executes during object creation, after setting all properties.
function edit1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Ortedt_Callback(hObject, eventdata, handles)
% hObject    handle to Ortedt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Ortedt as text
%        str2double(get(hObject,'String')) returns contents of Ortedt as a double

x0 = get(handles.Ortedt,'String')

    x0 = str2num(x0)
    
B0 = get(handles.Bslider,'Value');
E0 = get(handles.Eslider,'Value');
w = get(handles.Richtslider,'Value');
wi = w/180*pi;

Zeit = get(handles.edit1,'String');

    Zeit(strfind(Zeit,'s')) =[];
    tmax = str2num(Zeit);
if isempty(tmax)
    disp('Falsche Eingabe t max')
    disp('entweder nur Zahl oder gefolgt bei s')
    disp('typischer Wert 3e-06 s')
end

v0 = get(handles.edit3,'String');
    v0 = str2num(v0);
    
konstMagn(B0,E0,wi,tmax,x0,v0)
    

% --- Executes during object creation, after setting all properties.
function Ortedt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Ortedt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit3_Callback(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit3 as text
%        str2double(get(hObject,'String')) returns contents of edit3 as a double

v0 = get(handles.edit3,'String');

    v0 = str2num(v0);
    
B0 = get(handles.Bslider,'Value');
E0 = get(handles.Eslider,'Value');
w = get(handles.Richtslider,'Value');
wi = w/180*pi;

Zeit = get(handles.edit1,'String');

    Zeit(strfind(Zeit,'s')) =[];
    tmax = str2num(Zeit);
if isempty(tmax)
    disp('Falsche Eingabe t max')
    disp('entweder nur Zahl oder gefolgt bei s')
    disp('typischer Wert 3e-06 s')
end

x0 = get(handles.Ortedt,'String');
    x0 = str2num(x0);
    
konstMagn(B0,E0,wi,tmax,x0,v0)
    
% --- Executes during object creation, after setting all properties.
function edit3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function konstMagn(B0,E0,wi,tmax,x0,v0)

% Visualisierung der Bewegung eines Ions in einem konstanten elektrischen und magnetischen Feld

% Aufruf:  konstMagnDGL(t,y,qm,B0,Ex,Ey)
% B0 Magnetfeld in z-Richtung in Tesla
% Ex, Ez elektrisches Feld in V/m
% qm = q/m in As/kg q Ladung; m Masse

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

% Vers. 1.2 11/2014

% tmax = 3e-06;%-06;                    % Integrationsdauer
% y0 = [0;0;0;100;100;100];             % Anfangswerte in 
y0 = [x0,v0]';                        % x-y-z Richtung (hier 0;0;0)
                                      % Geschwindigkeiten vx-vy-vz (hier
                                      % 100;100;100)
qe = 1.602e-19;                       % C Elementarladung des Elektrons 
me = 9.1096e-31;                      % Masse des Elektrons
m = 1836*me*12;                       % Masse C-12 (5-fach ionisiert)
qm = qe/m;
%B0 = 3.7;                             % Magnetfeld in T (z-Richtung)
%E0= 0;-7.5;%e03;%0;                   % Betrag elektrisches Feld V/m
%wi = pi/2;  
% Richtung: Parallele Felder wi=0; senkrecht wi=pi/2;
Ez = E0 * cos(wi);
Ex = E0 * sin(wi);

tic
[t,y] = ode15s(@(t,y) konstMagnDGL(t,y,qm,B0,Ex,Ez),[0,tmax],y0);
toc

% Visualisierung
plot3(y(:,1),y(:,2),y(:,3))
xlabel('x'),ylabel('y'),zlabel('z'), shg
