%%
% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB -
close all,clear, clc
swingBy; % Bestimmen der Bahndaten und Darstellung der Bahn im ruhenden Jupitersystem
%%
figure
% AE = 777.8e09;   % Abstand Jupiter Sonne
% Bahnbewegung von Jupiter
% Berechnung des Winkels
T0 = 2*pi*sqrt(AE^3/G/m2);
phi=2*pi*t/T0;
x1Jup=AE*sin(phi);
x2Jup=AE*cos(phi);  % d.h die Bewegung verl??uft im Uhrzeigersinn
%% Visualisieren
x1S=y(:,1).*sin(y(:,2)+phi);
x2S=y(:,1).*cos(y(:,2)+phi);
x1=x1Jup+x1S;
x2=x2Jup+x2S;
plot(x1,x2,'k'),hold on, plot(x1(1),x2(1),'pr'),plot(x1Jup,x2Jup,'b')
plot(x1Jup(1),x2Jup(2),'pm'),axis equal, shg
title('Bahn im rotierenden System')
%% Geschwindigkeit Jupiter bez??glich Sonne
vbahn = 2*pi*AE/T0;
v1Jup = vbahn*cos(phi);
v2Jup = -vbahn*sin(phi);
%% Geschwindigkeit Satellit bezgl. Jupiter
% Winkelanteil
vwinkelb = y(:,4)./y(:,1)/mu;
v1Sbahn = vwinkelb .* cos(y(:,2)+phi);
v2Sbahn = -vwinkelb .* sin(y(:,2)+phi);
v1Sr    = y(:,3).*sin(y(:,2)+phi)/mu;
v2Sr    = y(:,3).*cos(y(:,2)+phi)/mu;
%% Geschwindigkeit Satellit
v1 = v1Jup+v1Sbahn+v1Sr;
v2 = v2Jup+v2Sbahn+v2Sr;
vg = sqrt(v1.^2+v2.^2);
%figure,plot(t,v1,t,v2,t,vg),shg
figure,plot(t,vg),grid on, shg
title('Geschwindigkeitsverlauf - Betrag')
verhaeltnis = vg(end)/vg(1);
X = fprintf('Geschwingkeitsverhaeltnis vorher-nachher: %6.4f\n', ...
    verhaeltnis);