function varargout = SatBahnErde(varargin)
% SATBAHNERDE MATLAB code for SatBahnErde.fig
%      SATBAHNERDE, by itself, creates a new SATBAHNERDE or raises the existing
%      singleton*.
%
%      H = SATBAHNERDE returns the handle to a new SATBAHNERDE or the handle to
%      the existing singleton*.
%
%      SATBAHNERDE('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SATBAHNERDE.M with the given input arguments.
%
%      SATBAHNERDE('Property','Value',...) creates a new SATBAHNERDE or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before SatBahnErde_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to SatBahnErde_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help SatBahnErde

% Last Modified by GUIDE v2.5 28-Dec-2013 14:57:52
% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB -

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @SatBahnErde_OpeningFcn, ...
                   'gui_OutputFcn',  @SatBahnErde_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before SatBahnErde is made visible.
function SatBahnErde_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to SatBahnErde (see VARARGIN)

% Choose default command line output for SatBahnErde
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes SatBahnErde wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = SatBahnErde_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function edith_Callback(hObject, eventdata, handles)
% hObject    handle to edith (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edith as text
%        str2double(get(hObject,'String')) returns contents of edith as a double


% --- Executes during object creation, after setting all properties.
function edith_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edith (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editex_Callback(hObject, eventdata, handles)
% hObject    handle to editex (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editex as text
%        str2double(get(hObject,'String')) returns contents of editex as a double


% --- Executes during object creation, after setting all properties.
function editex_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editex (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editn_Callback(hObject, eventdata, handles)
% hObject    handle to editn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editn as text
%        str2double(get(hObject,'String')) returns contents of editn as a double


% --- Executes during object creation, after setting all properties.
function editn_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on slider movement.
function slteta_Callback(hObject, eventdata, handles)
% hObject    handle to slteta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

theta = get(hObject,'Value');
theta = round(10*theta)/10;
set(handles.txtteta,'string',{['Neigung gegen'];['Polachse ',num2str(theta),'??']})


% --- Executes during object creation, after setting all properties.
function slteta_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slteta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end



function editm_Callback(hObject, eventdata, handles)
% hObject    handle to editm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editm as text
%        str2double(get(hObject,'String')) returns contents of editm as a double


% --- Executes during object creation, after setting all properties.
function editm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pbclear.
function pbclear_Callback(hObject, eventdata, handles)
% hObject    handle to pbclear (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
hold off,plot(0,0)

% --- Executes on button press in pbplot.
function pbplot_Callback(hObject, eventdata, handles)
% hObject    handle to pbplot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Vers.2.1 29.12.2013
%% Parameter und Konstanten
G = 6.67384e-11; % Gravitationskonstante

                 % Masse des Satelliten in kg
m1 = get(handles.editm,'string');
m1 = str2num(m1);
                 % Erddaten:
m2 = 5.977e24;   % Masse des Erde in kg
%AE = 1.496e11;  % Mittlere Entfernung Erde-Sonne in m = 1 astronomische Einheit (1AE)
ae = 6.378140e06; % mittlerer Erdradius in m
J2 = 0.001082626; % Multipolmomente der Erde 
J3 = -0.254e-05;
J4 = -0.161e-05;
Vorf = G*m1*m2;
mu = m1*m2/(m1+m2); % Reduzierte Masse
%% Bahnparameter festlegen
hoch=get(handles.edith,'string');  % H??he ??ber der Erde in km
rm = ae+str2num(hoch)*1000;                   % Abstand in m
epsilon = str2num(get(handles.editex,'String')); % Exzentrizit?t (0 Kreis stets <1; Erde: 0.0167)
%% Umlaufzeit
Tn = sqrt(4*pi^2/(G*m2)*rm.^3)/3600; disp(['Umlaufzeit in Stunden']),Tn 
n = str2num(get(handles.editn,'String'));  % Zahl der Orbits
%% Startwerte
r0 = (1+epsilon)*rm;   % Anfangswert: Aphel
theta0 = get(handles.slteta,'Value')*pi/180;  % Neigung gegen Polachse      
pr0=0;
%
E0 = -Vorf/(2*r0) * (1+epsilon); % Energie
pt0 = sqrt((E0*r0+Vorf)*2*mu*r0);
%% Differentialgleichung l??sen
y0 = [r0;theta0;pr0;pt0];
tmax=3600*Tn*n;
options = odeset('RelTol',1e-8,'AbsTol',1e-8,'MaxStep',3600*24);
tic
[t,y] = ode45(@(t,y) SatErdeDGL(t,y,mu,Vorf,ae,J2,J3,J4),[0,tmax],y0,options);
toc
%% Visualisieren
x1=y(:,1).*sin(y(:,2));
x2=y(:,1).*cos(y(:,2));
plot(x1,x2,'Color',rand(3,1)),hold on, plot(x1(1),x2(1),'pr'),plot(0,0,'yp'),axis equal, shg
hold on
zoom on

function dy = SatErdeDGL(t,y,m1,Vorf,ae,J2,J3,J4)
% Differentialgleichung

% Vers.2.0  17.12.2013
[mr,mt]=multipol(y,ae,J2,J3,J4);                    % Multipolmomente
%
dy(1) = y(3)/m1;                                             % r
dy(2) = y(4)/(m1*y(1)^2);                                    % theta
dy(3) = y(4)^2/(m1*y(1)^3) - Vorf/(y(1)^2)*(1+mr);           % p_r
dy(4) = Vorf/y(1)*mt;                                        % p_theta
%
dy = dy.';


function [mr,mt]=multipol(y,ae,J2,J3,J4)
% Berechnung der Legendre-Polynome
x = cos(y(2));
%P0 = 1;
%P1 = x;
P2 = 0.5*(3*x^2 - 1);
P3 = 0.5*(5*x^3 - 3*x);
P4 = 0.25*(7*x*P3 - 3*P2);
%
ris = ae/y(1);              % skalierter inverser Abstand
%
mr = 3*J2*ris^2*P2 + 4*J3*ris^3*P3 + 5*J4*ris^4*P4; % radiale Komponente

% Berechnung der Ableitung der Legendre-Polynome
dx = -sin(y(2));
dP2 = dx*3*x;
dP3 = dx*(7.5*x^2 - 1.5);
dP4 = 0.25*(7*(dx*P3 + x*dP3) -3*dP2);
%
mt = J2*ris^2*dP2 + J3*ris^3*dP3 + J4*ris^4*dP4; 
