function varargout = Planetenbahnen(varargin)
% PLANETENBAHNEN MATLAB code for Planetenbahnen.fig
%      PLANETENBAHNEN, by itself, creates a new PLANETENBAHNEN or raises the existing
%      singleton*.
%
%      H = PLANETENBAHNEN returns the handle to a new PLANETENBAHNEN or the handle to
%      the existing singleton*.
%
%      PLANETENBAHNEN('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in PLANETENBAHNEN.M with the given input arguments.
%
%      PLANETENBAHNEN('Property','Value',...) creates a new PLANETENBAHNEN or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Planetenbahnen_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Planetenbahnen_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Planetenbahnen

% Last Modified by GUIDE v2.5 26-Dec-2013 15:04:18

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB -

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Planetenbahnen_OpeningFcn, ...
                   'gui_OutputFcn',  @Planetenbahnen_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Planetenbahnen is made visible.
function Planetenbahnen_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Planetenbahnen (see VARARGIN)

% Choose default command line output for Planetenbahnen
handles.output = hObject;
handles.G = 6.67384e-11; % Gravitationskonstante
% Update handles structure
guidata(hObject, handles);

% Defaultwerte setzen
% Parameter und Konstanten
% G = 6.67384e-11; % Gravitationskonstante
m1 = 5.977e24;   % Masse des Erde in kg
m2 = 1.983e30;  % Masse der Sonne in kg
AE = 1.496e11;  % Mittlere Entfernung Erde-Sonne in m = 1 astronomische Einheit (1AE)
%Vorf = G*m1*m2;
epsilon =0.0167;%0.991;%0.5; % Exzentrizit?t (0 Kreis stets <1; Erde: 0.0167)
% 
set(handles.ePM,'string',num2str(m1))
set(handles.eZM,'string',num2str(m2))
set(handles.eAbstand,'string',num2str(AE))
set(handles.eExz,'string',num2str(epsilon))
set(handles.tbART,'Value',1)                    % Default ART an
%set(handles.lb_planeten,'ListBoxTop',3)
%get(handles.lb_planeten)
%setappdata(handles.figure1,'G',G)

% UIWAIT makes Planetenbahnen wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Planetenbahnen_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on selection change in lb_planeten.
function lb_planeten_Callback(hObject, eventdata, handles)
% hObject    handle to lb_planeten (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns lb_planeten contents as cell array
%        contents{get(hObject,'Value')} returns selected item from lb_planeten
wp=get(hObject,'value');
if wp==10
    h=helpdlg({'die in den Editierfeldern'; ...
        'Masse Sonne, Planet';'Abstand'; 'und Exzentrizit??t'; ...
        'eingetragenen Werte dienen der Berechnung'; ...
        'gegebenenfalls anpassen und dann ''Plotten'' anklicken'},...
        'Info zu ''Eigene Werte''');
end

    
[m1,m2,AE,epsilon] = Planetendaten(wp,handles);


% --- Executes during object creation, after setting all properties.
function lb_planeten_CreateFcn(hObject, eventdata, handles)
% hObject    handle to lb_planeten (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in tbART.
function tbART_Callback(hObject, eventdata, handles)
% hObject    handle to tbART (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of tbART

artwert=get(hObject,'Value');
if artwert==0
    set(hObject,'String','ART:An/Aus - Aus');
else
    set(hObject,'String','ART:An/Aus - An');
end

function eZM_Callback(hObject, eventdata, handles)
% hObject    handle to eZM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of eZM as text
%        str2double(get(hObject,'String')) returns contents of eZM as a double


m2=str2num(get(handles.eZM,'string'));
AE=str2num(get(handles.eAbstand,'string'));
G = 6.67384e-11; % Gravitationskonstante

Periode =  num2str(ceil(2*pi*sqrt(1/(G*m2))*AE^(3/2)/3600/24*10)/10);% 'Tage';

set(handles.Tage,'ToolTipString',['Plot-Zeitraum dagegen Periode = ',Periode])


% --- Executes during object creation, after setting all properties.
function eZM_CreateFcn(hObject, eventdata, handles)
% hObject    handle to eZM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% 


function ePM_Callback(hObject, eventdata, handles)
% hObject    handle to ePM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ePM as text
%        str2double(get(hObject,'String')) returns contents of ePM as a double


% --- Executes during object creation, after setting all properties.
function ePM_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ePM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function eAbstand_Callback(hObject, eventdata, handles)
% hObject    handle to eAbstand (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of eAbstand as text
%        str2double(get(hObject,'String')) returns contents of eAbstand as a double

m2=str2num(get(handles.eZM,'string'));
AE=str2num(get(handles.eAbstand,'string'));
G = 6.67384e-11; % Gravitationskonstante

Periode =  num2str(ceil(2*pi*sqrt(1/(G*m2))*AE^(3/2)/3600/24*10)/10);% 'Tage';

set(handles.Tage,'ToolTipString',['Plot-Zeitraum dagegen Periode = ',Periode])

% --- Executes during object creation, after setting all properties.
function eAbstand_CreateFcn(hObject, eventdata, handles)
% hObject    handle to eAbstand (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function eExz_Callback(hObject, eventdata, handles)
% hObject    handle to eExz (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of eExz as text
%        str2double(get(hObject,'String')) returns contents of eExz as a double


% --- Executes during object creation, after setting all properties.
function eExz_CreateFcn(hObject, eventdata, handles)
% hObject    handle to eExz (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pbPlot.
function pbPlot_Callback(hObject, eventdata, handles)
% hObject    handle to pbPlot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


wp=get(handles.lb_planeten,'value');
artwert=get(handles.tbART,'Value');
[m1,m2,AE,epsilon] = Planetendaten(wp,handles);

G = 6.67384e-11; % Gravitationskonstante
mu = m1*m2/(m1+m2); % Reduzierte Masse
Vorf = G*m1*m2;
%% Startwerte
%epsilon =0.0167;%0.991;%0.5; % Exzentrizit?t (0 Kreis stets <1; Erde: 0.0167)
r0 = (1+epsilon)*AE;   % Anfangswert: Aphel
theta0 = 0;      
pr0=0;
%
E0 = -Vorf/(2*r0) * (1+epsilon); % Energie
pt0 = sqrt((E0*r0+Vorf)*2*mu*r0);
%% Differentialgleichung l??sen
y0 = [r0;theta0;pr0;pt0];
n=str2num(get(handles.Tage,'String'));
%n = 365.75;%*10;%*2; % Anzahl der Tage
tmax=24*3600*n;
options = odeset('RelTol',1e-8,'AbsTol',1e-8,'MaxStep',3600*24);
tic % (t,y,m1,Vorf,m2,G,ART)
[t,y] = ode45(@(t,y) keplerDGL(t,y,mu,Vorf,m2,G,artwert),[0,tmax],y0,options);
toc
%% Visualisieren
x1=y(:,1).*sin(y(:,2));
x2=y(:,1).*cos(y(:,2));
plot(x1,x2,'color',rand(1,3)),hold on, plot(x1(1),x2(1),'pr'),plot(0,0,'yp'),axis equal, shg
zoom on


function [m1,m2,AE,epsilon] = Planetendaten(wp,handles)

% Parameter und Konstanten
G = 6.67384e-11;      % Gravitationskonstante
m1 = 5.977e24;        % Masse des Erde in kg
m2 = 1.983e30;        % Masse der Sonne in kg
AE = 1.496e11*0.999;  % Mittlere Entfernung Erde-Sonne in m = 1 astronomische Einheit (1AE)

epsilon =0.0167;%0.991;%0.5; % Exzentrizit?t (0 Kreis stets <1; Erde: 0.0167)

% wp, isnumeric(wp)
% handles

switch wp
    case 1  % Merkur
        m1 = 0.037*m1;
        AE = 57.8e09;
        epsilon = 0.2056;
    case 2   % Venus
        m1 = 0.826*m1;
        AE = 108.1e09;
        epsilon = 0.0068;
    case 3 % Erde
        % Defaultwerte 'oben'
    case 4    % Mars
        m1 = 0.108*m1;
        AE = 227.7e09;
        epsilon = 0.0934;
    case 5    % Jupiter
        m1 = 318.36*m1;
        AE = 777.8e09;
        epsilon = 0.0484;
    case 6    % Saturn
        m1 = 95.22*m1;
        AE = 1425.6e09;
        epsilon = 0.0558;
    case 7    % Uranus
        m1 = 14.58*m1;
        AE = 2868.1e09;
        epsilon = 0.0471;
    case 8    % Neptun
        m1 = 17.27*m1;
        AE = 4494.1e09;
        epsilon = 0.0086;
    case 9    % Pluto
        m1 = 0.0021*m1;
        AE = 5906e09;
        epsilon = 0.2468;
    case 10    % eigen
        m1 = str2num(get(handles.ePM,'string'));
        m2 = str2num(get(handles.eZM,'string'));
        AE = str2num(get(handles.eAbstand,'string'));
        epsilon = str2num(get(handles.eExz,'string'));
end

set(handles.ePM,'string',num2str(m1))
set(handles.eZM,'string',num2str(m2))
set(handles.eAbstand,'string',num2str(AE))
set(handles.eExz,'string',num2str(epsilon))
        
%Vorf = G*m1*m2;
%mu = m1*m2/(m1+m2); % Reduzierte Masse
Periode =  num2str(ceil(2*pi*sqrt(1/(G*m2))*AE^(3/2)/3600/24*10)/10);% 'Tage';

set(handles.Tage,'ToolTipString',['Plot-Zeitraum dagegen Periode = ',Periode])


function Tage_Callback(hObject, eventdata, handles)
% hObject    handle to Tage (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Tage as text
%        str2double(get(hObject,'String')) returns contents of Tage as a double


% --- Executes during object creation, after setting all properties.
function Tage_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Tage (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in tbClear.
function tbClear_Callback(hObject, eventdata, handles)
% hObject    handle to tbClear (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of tbClear

handles.figure1; hold off; plot(0,0); zoom off

function dy = keplerDGL(t,y,m1,Vorf,m2,G,ART)
% Differentialgleichung

% Vers.2.0  21.12.2013  --> ART-Korrektur 
% m1 ist die reduzierte Masse
if ART == 0
    y2art = 0;
    y3art = 0;
else
    [y2art,y3art] = ARTkorr(y,m1,m2,G);
end


dy(1) = y(3)/m1;
dy(2) = y(4)/(m1*y(1)^2) + y2art;
dy(3) = y(4)^2/(m1*y(1)^3) - Vorf/(y(1)^2) + y3art;
dy(4) = 0;
dy = dy.';

function [y2art,y3art] = ARTkorr(y,m1,m2,G)

% N??herungsweise Berechnung der Korrekturen der allg. Relativit??tstheorie
% Reduzierte Masse durch Planetenmasse m1 ersetzt

cq = 2.99792e08^2; % Lichgeschwindigkeit in m/s zum Quadrat
mf = G*((m1+m2)^2)/(m1*m2*cq*y(1)^3); 

y2art = -2*y(4)*mf;
y3art = -3*y(4)^2*mf/y(1);
