%% Visualisierung der Schwarzschildmetrik
%

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

clear, close all, clc

rs = 1;            % Schwarzschildradius
nab = 3;           % wo soll abgeschnitten werden
r = rs*nab:1:100;
theta = 0:pi/20:2*pi;
[Theta,r] = meshgrid(theta,r);
x = r.*sin(Theta);
y = r.*cos(Theta);
z = 2*sqrt(r-1);
figure
surf(x,y,z),shg