%% Relativistischer Dopplereffekt
%
% Beta = v/c  Geschwindigkeit
% fd = f/f0 f0 Eigenfrequenz des Lichts, f beim Beobachter fd relativer
% Wert --> fb = fs * fd 

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016

clear, close all, clc
%%
fd = @(x,alpha) sqrt(1-x.^2)./(1-x.*cos(alpha)); % longitudinaler Dopplereffekt für alpha = 0, pi und 
                                              % tranversaler Dopplereffekt für alpha = pi/2.
                                              % Im Gegensatz zur
                                              % klassischen Schallwelle
                                              % verschwindet der
                                              % Dopplereffekt nicht bei
                                              % senkrechter Bewegung.
                                              % Tatsächlich hängt dies von
                                              % der Geschwindigkeit ab 
                                              
x = linspace(0,0.99);                         % x = beta
plot(x,fd(x,0),x,fd(x,pi/2),x,fd(x,pi)),shg
xlabel('\beta'), ylabel('f\f0'), legend('0','90','180')
%% Winkel unter dem der rel. Dopplereffekt verschwindet (klassisch pi/2)
winkel = @(x) acos((1-sqrt(1-x.^2))./x);
vc = linspace(eps,1);
figure
plot(vc,winkel(vc)*180/pi),axis tight,grid on,xlabel('\beta'),ylabel('\alpha'),shg
%%
alpha=linspace(0,pi);
figure
plot(alpha*180/pi,fd(0.5,alpha)),grid on,shg                   %fd(beta,winkel)
hold on
plot(alpha*180/pi,fd(0.25,alpha),'m'),grid on,shg
plot(alpha*180/pi,fd(0.05,alpha),'g'),grid on,axis tight,shg
plot(alpha*180/pi,fd(-0.5,alpha),'r'),grid on,axis tight, shg
%% Visualisierung 
figure
subplot(1,2,1)
plot(x,fd(x,0),x,fd(x,pi/2),x,fd(x,pi)),shg
xlabel('\beta'), ylabel('f\f0'), legend('0','90','180')
subplot(1,2,2)
plot(vc,winkel(vc)*180/pi),axis tight,grid on,xlabel('\beta'),ylabel('\alpha'),shg
        % winkel ist der Wert unter dem rel. Dopplereffekt verschwindet