%% Beispiel zur Visualisierung bewegter Objekte

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016


close all, clear, clc
%% Lorentz-Transformation
alpha = 0.99;                            % cosh(alpha) = gamma
Lambda = [cosh(alpha) 0 0 sinh(alpha)
               0      1 0      0
               0      0 1      0
          sinh(alpha) 0 0 cosh(alpha)];
%
phi = linspace(0,2*pi);
x = sin(phi);
z = cos(phi);
t = zeros(size(x));
y = t;
%
koord = [t;x;y;z];                       % Kreis im ruhenden System
koordTrafo = Lambda*koord;               % Beobachter mit alpha 
%% Darstellung Kreis
subplot(1,2,1)
plot(koord(2,:),koord(4,:))
hold on
plot(koordTrafo(2,:),koordTrafo(4,:)), axis equal, axis off
xlabel('x'), ylabel('y')
%% Eigenzeiten in Anhaengigkeit vom Winkel
phi = atan2(x,z)*180/pi;
subplot(1,2,2)
plot(phi(1:50),koordTrafo(1,1:50)), hold on
plot(phi(51:end),koordTrafo(1,51:end)), shg
plot([-180,180],[0,0]), shg
%% Transformation eines beliebigen Objekts 
% wie oben m"oglich
% x und z-Koordinaten vorgeben
phi = linspace(0,2*pi);    % bitte aendern
x = sin(2*phi);            % bitte aendern
z = cos(phi);              % bitte aendern
t = zeros(size(x));        % bleibt unveraendert
y = t;
koord = [t;x;y;z];         % Im ruhenden System
koordTrafo = Lambda*koord; % Beobachter mit alpha 
figure
plot(x,z), hold on, shg
% weitere Darstellungen
figure
plot(koordTrafo(2,:),koordTrafo(4,:)), axis equal, axis off
xlabel('x'), ylabel('y')