
%%  Gravitationswelle - Wirkung auf Zylinder

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% 2016
% Vers.1.0 22.08.2016


figure                      % Erstellen des Zylinders
n = 20;
r = ones(n+1,1);
m = length(r);
theta = (0:n)/n*2*pi;
sintheta = sin(theta); sintheta(n+1) = 0;
x = r * cos(theta);
y = r * sintheta;
z = pi/2*(0:m-1)'/(m-1) * ones(1,n+1);
%
omega = 1;
ti = linspace(0,pi/2,100);
ti = [ti,fliplr(ti),ti,fliplr(ti)];   % Zeitschritte
j=0;
for t=ti                              % Durchlaufen der einzelnen Zeitpunkte
    j=j+1;
    h = 0.75*cos(omega*(t-z));
    xn = x.*sqrt(1+h);
    yn = y.*sqrt(1-h);
    surf(xn,yn,z)%, axis equal
    drawnow
    F(j) = getframe;
end
%%  Gravitationswelle - Polarisationen
% Zeitlicher Verlauf der periodischen Raumaenderungen
phi = linspace(0,2*pi);
x = sin(phi);
y = cos(phi);
figure('Color',[1,1,1])
%
Tl = [0,pi/2,pi,3*pi/2,pi];
np=0;
xtext={'0','T/4','T/2','3T/4','T'};
for T=Tl
    hp = 0.5*sin(T);
    np=np+1;
    x = sin(phi);
    y = cos(phi);
    x = x.*sqrt(1+hp);
    y = y.*sqrt(1-hp);
    subplot(2,5,np)
    plot(x,y,'k','LineWidth',2)
    hold on
    plot([0,0],[-1,+1],'k',[-1,1],[0,0],'k'),axis equal,axis off
    xlabel(xtext{np})
    xn = 1/2*sqrt(2)*(x+y);
    yn = 1/2*sqrt(2)*(x-y);
    subplot(2,5,np+5)
    plot(xn,yn,'k','LineWidth',2),axis equal,axis off
    hold on
    plot([0,0],[-1,+1],'k',[-1,1],[0,0],'k'),axis equal,axis off
end