function varargout = hysteresegui(varargin)
% HYSTERESEGUI MATLAB code for hysteresegui.fig
%      HYSTERESEGUI, by itself, creates a new HYSTERESEGUI or raises the existing
%      singleton*.
%
%      H = HYSTERESEGUI returns the handle to a new HYSTERESEGUI or the handle to
%      the existing singleton*.
%
%      HYSTERESEGUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in HYSTERESEGUI.M with the given input arguments.
%
%      HYSTERESEGUI('Property','Value',...) creates a new HYSTERESEGUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before hysteresegui_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to hysteresegui_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help hysteresegui

% Last Modified by GUIDE v2.5 12-Oct-2014 14:19:34

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB -
% Version 2

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @hysteresegui_OpeningFcn, ...
                   'gui_OutputFcn',  @hysteresegui_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before hysteresegui is made visible.
function hysteresegui_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to hysteresegui (see VARARGIN)

% Choose default command line output for hysteresegui
handles.output = hObject;
setappdata(handles.sliderb,'ball',-5)
myplot(handles)

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes hysteresegui wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = hysteresegui_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function edta_Callback(hObject, eventdata, handles)
% hObject    handle to edta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edta as text
%        str2double(get(hObject,'String')) returns contents of edta as a double

a=str2num(get(handles.edta,'String'));
if a>= 0
    disp('a muss negativ sein')
    if a == 0
        a = -12;
    else
        disp('setze a = -a')
        a = -a;
    end
    set(handles.edta,'String',num2str(a))
end
    
        
    
xwende = sqrt(-a/3);
% Soll Sattelpunkt sein
bsattel = -xwende^3-a*xwende;
bmax = 1.25 * bsattel;
bmax = ceil(10*bmax)/10; 
bgrenz = get(handles.sliderb,'Value');
if abs(bgrenz)>bmax
    set(handles.sliderb,'Value',sign(bgrenz)*bmax)
end
set(handles.sliderb,'Max',bmax);
set(handles.sliderb,'Min',-bmax);
set(handles.txtbmax,'String',num2str(bmax));
set(handles.txtbmin,'String',num2str(-bmax));
set(handles.txtslider,'String',num2str(get(handles.sliderb,'Value')))
myplot(handles)


% --- Executes during object creation, after setting all properties.
function edta_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on slider movement.
function sliderb_Callback(hObject, eventdata, handles)
% hObject    handle to sliderb (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

baktuell=get(handles.sliderb,'value');
set(handles.txtslider,'String',num2str(baktuell))
%WerteBerechnen(handles)
myplot(handles)

% --- Executes during object creation, after setting all properties.
function sliderb_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sliderb (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end

function [xgrenz,a]=WerteBerechnen(handles)
%handles
bmax = get(handles.sliderb,'Max');
a = str2num(get(handles.edta,'String'));

xnullAll = roots([1 0 a  bmax]);
xgrenz = floor(1.15*xnullAll(1));

function myplot(handles)

[xgrenz,a] = WerteBerechnen(handles);
x = linspace(xgrenz,-xgrenz);
b = get(handles.sliderb,'Value');
%
hyster = @(a,b,x) polyval([1/4 0 a/2 b 0],x);
%plot(x,hyster(a,b,x))

xballv=getappdata(handles.sliderb,'ball');
minimar = roots([1 0 a b]);
MinimumWert = [];
for k=1:length(minimar)
    if isreal(minimar(k))
        MinimumWert = [MinimumWert;minimar(k)];
    end
end
if isempty(MinimumWert)
    disp('Komplex'),minimar
end
% Maximum herauswerfen
if length(MinimumWert) == 3
    MinimumWert(3) = [];
end
%MinimumWert
[w,index]=min(abs(MinimumWert-xballv));
xball=MinimumWert(index);
setappdata(handles.sliderb,'ball',xball)
yball=polyval([1/4 0 a/2 b 0],xball);
plot(x,hyster(a,b,x),xball,yball,'o')
axis tight
