function dy = foucault_dgl(t,y,g,l,omega,lam)

% lam geographische Breite ; 
% omega Winkelgeschwindigkeit der Erde
% g Erdbeschleunigung und l Laenge des Pendels
% y(1) x-Richtung y(2) y-Richtung ; y(3) und y(4) zugehoerige
% Geschwindigkeiten

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB -
% Vers. 1.2
% 02.2015

slam = 2.*omega.*sin(lam);
clam = 2.*omega.*cos(lam)./l;
gl = g/l;
%
dy(1) = y(3);
dy(2) = y(4);
%
dy(3) = slam.*y(4) + clam.*y(1).*y(4) - gl.*y(1);
dy(4) = -slam .* y(3) + clam.*y(2).*y(4) - gl .* y(2);

dy = dy.';